/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.casechanger;

import java.util.stream.Collectors;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.formatter.casechanger.LowerCaseFormatter;
import org.jabref.logic.formatter.casechanger.Title;
import org.jabref.logic.formatter.casechanger.Word;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.strings.StringUtil;

public class SentenceCaseFormatter
extends Formatter {
    @Override
    public String getName() {
        return Localization.lang("Sentence case", new Object[0]);
    }

    @Override
    public String getKey() {
        return "sentence_case";
    }

    @Override
    public String format(String input) {
        return StringUtil.getStringAsSentences(input).stream().map(new LowerCaseFormatter()::format).map(Title::new).map(title -> {
            title.getFirstWord().ifPresent(Word::toUpperFirst);
            return title;
        }).map(Object::toString).collect(Collectors.joining(" "));
    }

    @Override
    public String getDescription() {
        return Localization.lang("Capitalize the first word, changes other words to lower case.", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "i have {Aa} DREAM";
    }
}

