/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.IdBasedFetcher;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.ParserFetcher;
import org.jabref.logic.net.ProgressInputStream;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IdBasedParserFetcher
extends IdBasedFetcher,
ParserFetcher {
    public static final Logger LOGGER = LoggerFactory.getLogger(IdBasedParserFetcher.class);

    public URL getUrlForIdentifier(String var1) throws URISyntaxException, MalformedURLException, FetcherException;

    public Parser getParser();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    default public Optional<BibEntry> performSearchById(String identifier) throws FetcherException {
        if (StringUtil.isBlank(identifier)) {
            return Optional.empty();
        }
        try (ProgressInputStream stream = this.getUrlDownload(this.getUrlForIdentifier(identifier)).asInputStream();){
            List<BibEntry> fetchedEntries222 = this.getParser().parseEntries(stream);
            if (fetchedEntries222.isEmpty()) {
                Optional<BibEntry> optional = Optional.empty();
                return optional;
            }
            if (fetchedEntries222.size() > 1) {
                LOGGER.info("Fetcher {} found more than one result for identifier {}. We will use the first entry.", (Object)this.getName(), (Object)identifier);
            }
            BibEntry entry = fetchedEntries222.getFirst();
            this.doPostCleanup(entry);
            Optional<BibEntry> optional = Optional.of(entry);
            return optional;
        }
        catch (URISyntaxException e) {
            throw new FetcherException("Search URI is malformed", e);
        }
        catch (IOException e) {
            Throwable throwable = e.getCause();
            if (!(throwable instanceof FetcherException)) throw new FetcherException("A network error occurred", e);
            FetcherException fe = (FetcherException)throwable;
            throw fe;
        }
        catch (ParseException e) {
            throw new FetcherException("An internal parser error occurred", e);
        }
    }
}

