/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.collections.ObservableList;
import org.jabref.logic.citationkeypattern.CitationKeyPatternPreferences;
import org.jabref.logic.importer.ImportException;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ImporterPreferences;
import org.jabref.logic.importer.OpenDatabase;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fileformat.BiblioscapeImporter;
import org.jabref.logic.importer.fileformat.BibtexImporter;
import org.jabref.logic.importer.fileformat.CffImporter;
import org.jabref.logic.importer.fileformat.CitaviXmlImporter;
import org.jabref.logic.importer.fileformat.CopacImporter;
import org.jabref.logic.importer.fileformat.EndnoteImporter;
import org.jabref.logic.importer.fileformat.EndnoteXmlImporter;
import org.jabref.logic.importer.fileformat.InspecImporter;
import org.jabref.logic.importer.fileformat.IsiImporter;
import org.jabref.logic.importer.fileformat.MedlineImporter;
import org.jabref.logic.importer.fileformat.MedlinePlainImporter;
import org.jabref.logic.importer.fileformat.ModsImporter;
import org.jabref.logic.importer.fileformat.MsBibImporter;
import org.jabref.logic.importer.fileformat.OvidImporter;
import org.jabref.logic.importer.fileformat.PdfContentImporter;
import org.jabref.logic.importer.fileformat.PdfEmbeddedBibFileImporter;
import org.jabref.logic.importer.fileformat.PdfGrobidImporter;
import org.jabref.logic.importer.fileformat.PdfMergeMetadataImporter;
import org.jabref.logic.importer.fileformat.PdfVerbatimBibTextImporter;
import org.jabref.logic.importer.fileformat.PdfXmpImporter;
import org.jabref.logic.importer.fileformat.RepecNepImporter;
import org.jabref.logic.importer.fileformat.RisImporter;
import org.jabref.logic.importer.fileformat.SilverPlatterImporter;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabases;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.util.FileUpdateMonitor;

public class ImportFormatReader {
    public static final String BIBTEX_FORMAT = "BibTeX";
    private final List<Importer> formats = new ArrayList<Importer>();
    private final ImporterPreferences importerPreferences;
    private final ImportFormatPreferences importFormatPreferences;
    private final FileUpdateMonitor fileUpdateMonitor;
    private final CitationKeyPatternPreferences citationKeyPatternPreferences;

    public ImportFormatReader(ImporterPreferences importerPreferences, ImportFormatPreferences importFormatPreferences, CitationKeyPatternPreferences citationKeyPatternPreferences, FileUpdateMonitor fileUpdateMonitor) {
        this.importerPreferences = importerPreferences;
        this.importFormatPreferences = importFormatPreferences;
        this.fileUpdateMonitor = fileUpdateMonitor;
        this.citationKeyPatternPreferences = citationKeyPatternPreferences;
        this.reset();
    }

    public void reset() {
        this.formats.add(new CopacImporter());
        this.formats.add(new EndnoteImporter());
        this.formats.add(new EndnoteXmlImporter(this.importFormatPreferences));
        this.formats.add(new InspecImporter());
        this.formats.add(new IsiImporter());
        this.formats.add(new MedlineImporter());
        this.formats.add(new MedlinePlainImporter(this.importFormatPreferences));
        this.formats.add(new ModsImporter(this.importFormatPreferences));
        this.formats.add(new MsBibImporter());
        this.formats.add(new OvidImporter());
        this.formats.add(new PdfMergeMetadataImporter(this.importFormatPreferences));
        this.formats.add(new PdfVerbatimBibTextImporter(this.importFormatPreferences));
        this.formats.add(new PdfContentImporter());
        this.formats.add(new PdfEmbeddedBibFileImporter(this.importFormatPreferences));
        if (this.importFormatPreferences.grobidPreferences().isGrobidEnabled()) {
            this.formats.add(new PdfGrobidImporter(this.importFormatPreferences));
        }
        this.formats.add(new PdfXmpImporter(this.importFormatPreferences.xmpPreferences()));
        this.formats.add(new RepecNepImporter(this.importFormatPreferences));
        this.formats.add(new RisImporter());
        this.formats.add(new SilverPlatterImporter());
        this.formats.add(new CffImporter(this.citationKeyPatternPreferences));
        this.formats.add(new BiblioscapeImporter());
        this.formats.add(new BibtexImporter(this.importFormatPreferences, this.fileUpdateMonitor));
        this.formats.add(new CitaviXmlImporter());
        this.formats.addAll((Collection<Importer>)this.importerPreferences.getCustomImporters());
    }

    private Optional<Importer> getByCliId(String cliId) {
        for (Importer format : this.formats) {
            if (!format.getId().equals(cliId)) continue;
            return Optional.of(format);
        }
        return Optional.empty();
    }

    public ParserResult importFromFile(String format, Path file) throws ImportException {
        Optional<Importer> importer = this.getByCliId(format);
        if (importer.isEmpty()) {
            throw new ImportException(Localization.lang("Unknown import format", new Object[0]) + ": " + format);
        }
        try {
            return importer.get().importDatabase(file);
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
    }

    public SortedSet<Importer> getImportFormats() {
        return new TreeSet<Importer>(this.formats);
    }

    public UnknownFormatImport importUnknownFormat(Path filePath, FileUpdateMonitor fileMonitor) throws ImportException {
        Objects.requireNonNull(filePath);
        try {
            UnknownFormatImport unknownFormatImport = this.importUnknownFormat((Importer importer) -> importer.importDatabase(filePath), (Importer importer) -> importer.isRecognizedFormat(filePath));
            unknownFormatImport.parserResult.setPath(filePath);
            return unknownFormatImport;
        }
        catch (ImportException e) {
            try {
                ParserResult parserResult = OpenDatabase.loadDatabase(filePath, this.importFormatPreferences, fileMonitor);
                if (parserResult.getDatabase().hasEntries() || !parserResult.getDatabase().hasNoStrings()) {
                    parserResult.setPath(filePath);
                    return new UnknownFormatImport(BIBTEX_FORMAT, parserResult);
                }
                throw new ImportException(parserResult.getErrorMessage());
            }
            catch (IOException ignore) {
                throw new ImportException(Localization.lang("Could not find a suitable import format.", new Object[0]));
            }
        }
    }

    private UnknownFormatImport importUnknownFormat(CheckedFunction<Importer, ParserResult> importDatabase, CheckedFunction<Importer, Boolean> isRecognizedFormat) throws ImportException {
        ObservableList<BibEntry> bestResult = null;
        int bestResultCount = 0;
        String bestFormatName = null;
        for (Importer imFo : this.formats) {
            try {
                if (!isRecognizedFormat.apply(imFo).booleanValue()) continue;
                ParserResult parserResult = importDatabase.apply(imFo);
                ObservableList<BibEntry> entries = parserResult.getDatabase().getEntries();
                BibDatabases.purgeEmptyEntries(entries);
                int entryCount = entries.size();
                if (entryCount <= bestResultCount) continue;
                bestResult = entries;
                bestResultCount = entryCount;
                bestFormatName = imFo.getName();
            }
            catch (IOException iOException) {}
        }
        if (bestResult != null) {
            ParserResult parserResult = new ParserResult((Collection<BibEntry>)bestResult);
            return new UnknownFormatImport(bestFormatName, parserResult);
        }
        throw new ImportException(Localization.lang("Could not find a suitable import format.", new Object[0]));
    }

    public UnknownFormatImport importUnknownFormat(String data) throws ImportException {
        Objects.requireNonNull(data);
        return this.importUnknownFormat((Importer importer) -> importer.importDatabase(data), (Importer importer) -> importer.isRecognizedFormat(data));
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws IOException;
    }

    public record UnknownFormatImport(String format, ParserResult parserResult) {
    }
}

