/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Objects;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.FileType;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseModeDetection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Importer
implements Comparable<Importer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Importer.class);

    public abstract boolean isRecognizedFormat(BufferedReader var1) throws IOException;

    public boolean isRecognizedFormat(Path filePath) throws IOException {
        try (BufferedReader bufferedReader = Importer.getReader(filePath);){
            boolean bl = this.isRecognizedFormat(bufferedReader);
            return bl;
        }
    }

    public boolean isRecognizedFormat(String data) throws IOException {
        try (StringReader stringReader = new StringReader(data);){
            boolean bl;
            try (BufferedReader bufferedReader = new BufferedReader(stringReader);){
                bl = this.isRecognizedFormat(bufferedReader);
            }
            return bl;
        }
    }

    public abstract ParserResult importDatabase(BufferedReader var1) throws IOException;

    public ParserResult importDatabase(Path filePath) throws IOException {
        try (InputStream inputStream = Files.newInputStream(filePath, StandardOpenOption.READ);){
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            Charset charset = StandardCharsets.UTF_8;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, charset));
            ParserResult parserResult = this.importDatabase(bufferedReader);
            parserResult.getMetaData().setEncoding(charset);
            parserResult.setPath(filePath);
            if (parserResult.getMetaData().getMode().isEmpty()) {
                parserResult.getMetaData().setMode(BibDatabaseModeDetection.inferMode(parserResult.getDatabase()));
            }
            ParserResult parserResult2 = parserResult;
            return parserResult2;
        }
    }

    protected static Charset getCharset(BufferedInputStream bufferedInputStream) {
        Charset defaultCharSet = StandardCharsets.UTF_8;
        CharsetDetector charsetDetector = new CharsetDetector();
        try {
            charsetDetector.setText((InputStream)bufferedInputStream);
            CharsetMatch[] matches = charsetDetector.detectAll();
            if (matches == null || matches.length == 0) {
                return defaultCharSet;
            }
            if (Arrays.stream(matches).anyMatch(charset -> "ASCII".equals(charset.getName()))) {
                return defaultCharSet;
            }
            if (matches[0] != null) {
                return Charset.forName(matches[0].getName());
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not determine charset. Using default one.", (Throwable)e);
        }
        return defaultCharSet;
    }

    public ParserResult importDatabase(String data) throws IOException {
        try (StringReader stringReader = new StringReader(data);){
            ParserResult parserResult;
            try (BufferedReader bufferedReader = new BufferedReader(stringReader);){
                parserResult = this.importDatabase(bufferedReader);
            }
            return parserResult;
        }
    }

    public static BufferedReader getReader(Path filePath) throws IOException {
        InputStream stream = Files.newInputStream(filePath, StandardOpenOption.READ);
        if (FileUtil.isBibFile(filePath)) {
            return Importer.getReader(stream);
        }
        return new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    public static BufferedReader getReader(InputStream stream) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(stream);
        Charset charset = Importer.getCharset(bufferedInputStream);
        InputStreamReader reader = new InputStreamReader((InputStream)bufferedInputStream, charset);
        return new BufferedReader(reader);
    }

    public String getId() {
        String id = this.getName();
        StringBuilder result = new StringBuilder(id.length());
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract FileType getFileType();

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Importer)) {
            return false;
        }
        Importer other = (Importer)obj;
        return Objects.equals(this.getName(), other.getName());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Importer o) {
        return this.getName().compareTo(o.getName());
    }
}

