/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.jabref.logic.importer.fetcher.ComplexSearchQuery;

public class QueryParser {
    public Optional<ComplexSearchQuery> parseQueryStringIntoComplexQuery(String query) {
        try {
            StandardQueryParser parser = new StandardQueryParser();
            Query luceneQuery = parser.parse(query, "default");
            HashSet terms = new HashSet();
            QueryVisitor visitor = QueryVisitor.termCollector(terms);
            luceneQuery.visit(visitor);
            ArrayList<Term> sortedTerms = new ArrayList<Term>(terms);
            sortedTerms.sort(Comparator.comparing(Term::text).reversed());
            return Optional.of(ComplexSearchQuery.fromTerms(sortedTerms));
        }
        catch (IllegalArgumentException | IllegalStateException | QueryNodeException ex) {
            return Optional.empty();
        }
    }
}

