/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.fileformat.BibtexParser;
import org.jabref.logic.net.URLDownload;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BibsonomyScraper {
    private static final String BIBSONOMY_SCRAPER = "https://scraper.bibsonomy.org/service?url=";
    private static final String BIBSONOMY_SCRAPER_POST = "&format=bibtex";
    private static final Logger LOGGER = LoggerFactory.getLogger(BibsonomyScraper.class);

    private BibsonomyScraper() {
    }

    public static Optional<BibEntry> getEntry(String entryUrl, ImportFormatPreferences importFormatPreferences) {
        try {
            String cleanURL = entryUrl.replace("%", "%25").replace(":", "%3A").replace("/", "%2F").replace("?", "%3F").replace("&", "%26").replace("=", "%3D");
            URL url = new URL(BIBSONOMY_SCRAPER + cleanURL + BIBSONOMY_SCRAPER_POST);
            String bibtex = new URLDownload(url).asString();
            return BibtexParser.singleFromString(bibtex, importFormatPreferences);
        }
        catch (IOException ex) {
            LOGGER.warn("Could not download entry", (Throwable)ex);
            return Optional.empty();
        }
        catch (ParseException ex) {
            LOGGER.warn("Could not parse entry", (Throwable)ex);
            return Optional.empty();
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Could not get entry", (Throwable)ex);
            return Optional.empty();
        }
    }
}

