/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.lucene.index.Term;
import org.jabref.model.strings.StringUtil;

public class ComplexSearchQuery {
    private final List<String> defaultField;
    private final List<String> authors;
    private final List<String> titlePhrases;
    private final List<String> abstractPhrases;
    private final Integer fromYear;
    private final Integer toYear;
    private final Integer singleYear;
    private final String journal;
    private final String doi;

    private ComplexSearchQuery(List<String> defaultField, List<String> authors, List<String> titlePhrases, List<String> abstractPhrases, Integer fromYear, Integer toYear, Integer singleYear, String journal, String doi) {
        this.defaultField = defaultField;
        this.authors = authors;
        this.titlePhrases = titlePhrases;
        this.abstractPhrases = abstractPhrases;
        this.fromYear = fromYear;
        this.toYear = toYear;
        this.journal = journal;
        this.singleYear = singleYear;
        this.doi = doi;
    }

    public static ComplexSearchQuery fromTerms(List<Term> terms) {
        ComplexSearchQueryBuilder builder = ComplexSearchQuery.builder();
        terms.forEach(term -> {
            String termText = term.text();
            switch (term.field().toLowerCase()) {
                case "author": {
                    builder.author(termText);
                    break;
                }
                case "title": {
                    builder.titlePhrase(termText);
                    break;
                }
                case "abstract": {
                    builder.abstractPhrase(termText);
                    break;
                }
                case "journal": {
                    builder.journal(termText);
                    break;
                }
                case "year": {
                    builder.singleYear(Integer.valueOf(termText));
                    break;
                }
                case "year-range": {
                    builder.parseYearRange(termText);
                    break;
                }
                case "doi": {
                    builder.DOI(termText);
                    break;
                }
                case "default": {
                    builder.defaultFieldPhrase(termText);
                    break;
                }
                default: {
                    builder.defaultFieldPhrase(termText);
                }
            }
        });
        return builder.build();
    }

    public List<String> getDefaultFieldPhrases() {
        return this.defaultField;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public List<String> getTitlePhrases() {
        return this.titlePhrases;
    }

    public List<String> getAbstractPhrases() {
        return this.abstractPhrases;
    }

    public Optional<Integer> getFromYear() {
        return Optional.ofNullable(this.fromYear);
    }

    public Optional<Integer> getToYear() {
        return Optional.ofNullable(this.toYear);
    }

    public Optional<Integer> getSingleYear() {
        return Optional.ofNullable(this.singleYear);
    }

    public Optional<String> getJournal() {
        return Optional.ofNullable(this.journal);
    }

    public Optional<String> getDOI() {
        return Optional.ofNullable(this.doi);
    }

    public static ComplexSearchQueryBuilder builder() {
        return new ComplexSearchQueryBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplexSearchQuery that = (ComplexSearchQuery)o;
        if (!this.getDefaultFieldPhrases().containsAll(that.getDefaultFieldPhrases()) || !that.getDefaultFieldPhrases().containsAll(this.getDefaultFieldPhrases())) {
            return false;
        }
        if (!this.getAuthors().containsAll(that.getAuthors()) || !that.getAuthors().containsAll(this.getAuthors())) {
            return false;
        }
        if (!this.getTitlePhrases().containsAll(that.getTitlePhrases()) || !that.getTitlePhrases().containsAll(this.getTitlePhrases())) {
            return false;
        }
        if (!this.getAbstractPhrases().containsAll(that.getAbstractPhrases()) || !that.getAbstractPhrases().containsAll(this.getAbstractPhrases())) {
            return false;
        }
        if (this.getFromYear().isPresent() ? !this.getFromYear().equals(that.getFromYear()) : that.getFromYear().isPresent()) {
            return false;
        }
        if (this.getToYear().isPresent() ? !this.getToYear().equals(that.getToYear()) : that.getToYear().isPresent()) {
            return false;
        }
        if (this.getSingleYear().isPresent() ? !this.getSingleYear().equals(that.getSingleYear()) : that.getSingleYear().isPresent()) {
            return false;
        }
        if (this.getDOI().isPresent() ? !this.getDOI().equals(that.getDOI()) : that.getDOI().isPresent()) {
            return false;
        }
        return this.getJournal().isPresent() ? this.getJournal().equals(that.getJournal()) : that.getJournal().isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.defaultField, this.getAuthors(), this.getSingleYear(), this.getAbstractPhrases(), this.getFromYear(), this.getToYear(), this.getTitlePhrases(), this.getJournal(), this.getDOI());
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(" ");
        this.getSingleYear().ifPresent(singleYear -> stringJoiner.add(singleYear.toString()));
        this.getFromYear().ifPresent(fromYear -> stringJoiner.add(fromYear.toString()));
        this.getToYear().ifPresent(toYear -> stringJoiner.add(toYear.toString()));
        this.getJournal().ifPresent(stringJoiner::add);
        this.getDOI().ifPresent(newElement -> stringJoiner.add("doi:" + newElement));
        stringJoiner.add(String.join((CharSequence)" ", this.getTitlePhrases())).add(String.join((CharSequence)" ", this.getDefaultFieldPhrases())).add(String.join((CharSequence)" ", this.getAuthors())).add(String.join((CharSequence)" ", this.getAbstractPhrases()));
        return stringJoiner.toString();
    }

    public static class ComplexSearchQueryBuilder {
        private final List<String> defaultFieldPhrases = new ArrayList<String>();
        private final List<String> authors = new ArrayList<String>();
        private final List<String> titlePhrases = new ArrayList<String>();
        private final List<String> abstractPhrases = new ArrayList<String>();
        private String journal;
        private String doi;
        private Integer fromYear;
        private Integer toYear;
        private Integer singleYear;

        private ComplexSearchQueryBuilder() {
        }

        public ComplexSearchQueryBuilder defaultFieldPhrase(String defaultFieldPhrase) {
            if (Objects.requireNonNull(defaultFieldPhrase).isBlank()) {
                throw new IllegalArgumentException("Parameter must not be blank");
            }
            this.defaultFieldPhrases.add("\"%s\"".formatted(defaultFieldPhrase.replace("\"", "")));
            return this;
        }

        public ComplexSearchQueryBuilder author(String author) {
            if (Objects.requireNonNull(author).isBlank()) {
                throw new IllegalArgumentException("Parameter must not be blank");
            }
            this.authors.add("\"%s\"".formatted(author.replace("\"", "")));
            return this;
        }

        public ComplexSearchQueryBuilder titlePhrase(String titlePhrase) {
            if (Objects.requireNonNull(titlePhrase).isBlank()) {
                throw new IllegalArgumentException("Parameter must not be blank");
            }
            this.titlePhrases.add("\"%s\"".formatted(titlePhrase.replace("\"", "")));
            return this;
        }

        public ComplexSearchQueryBuilder abstractPhrase(String abstractPhrase) {
            if (Objects.requireNonNull(abstractPhrase).isBlank()) {
                throw new IllegalArgumentException("Parameter must not be blank");
            }
            this.titlePhrases.add("\"%s\"".formatted(abstractPhrase.replace("\"", "")));
            return this;
        }

        public ComplexSearchQueryBuilder fromYearAndToYear(Integer fromYear, Integer toYear) {
            if (this.singleYear != null) {
                throw new IllegalArgumentException("You can not use single year and year range search.");
            }
            this.fromYear = Objects.requireNonNull(fromYear);
            this.toYear = Objects.requireNonNull(toYear);
            return this;
        }

        public ComplexSearchQueryBuilder singleYear(Integer singleYear) {
            if (this.fromYear != null || this.toYear != null) {
                throw new IllegalArgumentException("You can not use single year and year range search.");
            }
            this.singleYear = Objects.requireNonNull(singleYear);
            return this;
        }

        public ComplexSearchQueryBuilder journal(String journal) {
            if (Objects.requireNonNull(journal).isBlank()) {
                throw new IllegalArgumentException("Parameter must not be blank");
            }
            this.journal = "\"%s\"".formatted(journal.replace("\"", ""));
            return this;
        }

        public ComplexSearchQueryBuilder DOI(String doi) {
            if (Objects.requireNonNull(doi).isBlank()) {
                throw new IllegalArgumentException("Parameter must not be blank");
            }
            this.doi = doi.replace("\"", "");
            return this;
        }

        public ComplexSearchQueryBuilder terms(Collection<Term> terms) {
            terms.forEach(term -> {
                String termText = term.text();
                switch (term.field().toLowerCase()) {
                    case "author": {
                        this.author(termText);
                        break;
                    }
                    case "title": {
                        this.titlePhrase(termText);
                        break;
                    }
                    case "abstract": {
                        this.abstractPhrase(termText);
                        break;
                    }
                    case "journal": {
                        this.journal(termText);
                        break;
                    }
                    case "doi": {
                        this.DOI(termText);
                        break;
                    }
                    case "year": {
                        this.singleYear(Integer.valueOf(termText));
                        break;
                    }
                    case "year-range": {
                        this.parseYearRange(termText);
                        break;
                    }
                    case "default": {
                        this.defaultFieldPhrase(termText);
                    }
                }
            });
            return this;
        }

        public ComplexSearchQuery build() throws IllegalStateException {
            if (this.textSearchFieldsAndYearFieldsAreEmpty()) {
                throw new IllegalStateException("At least one text field has to be set");
            }
            return new ComplexSearchQuery(this.defaultFieldPhrases, this.authors, this.titlePhrases, this.abstractPhrases, this.fromYear, this.toYear, this.singleYear, this.journal, this.doi);
        }

        void parseYearRange(String termText) {
            String[] split = termText.split("-");
            int fromYear = 0;
            int toYear = 9999;
            try {
                fromYear = Integer.parseInt(split[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (split.length > 1) {
                try {
                    toYear = Integer.parseInt(split[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.fromYearAndToYear(fromYear, toYear);
        }

        private boolean textSearchFieldsAndYearFieldsAreEmpty() {
            return this.stringListIsBlank(this.defaultFieldPhrases) && this.stringListIsBlank(this.titlePhrases) && this.stringListIsBlank(this.authors) && this.stringListIsBlank(this.abstractPhrases) && StringUtil.isBlank(this.journal) && StringUtil.isBlank(this.doi) && this.yearFieldsAreEmpty();
        }

        private boolean yearFieldsAreEmpty() {
            return this.singleYear == null && this.fromYear == null && this.toYear == null;
        }

        private boolean stringListIsBlank(List<String> stringList) {
            return stringList == null || stringList.stream().allMatch(String::isBlank);
        }
    }
}

