/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.importer.EntryBasedFetcher;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.IdBasedFetcher;
import org.jabref.logic.importer.fetcher.JournalInformationFetcher;
import org.jabref.logic.journals.JournalInformation;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;

public class IssnFetcher
implements EntryBasedFetcher,
IdBasedFetcher {
    private final JournalInformationFetcher journalInformationFetcher = new JournalInformationFetcher();

    @Override
    public List<BibEntry> performSearch(BibEntry entry) throws FetcherException {
        Optional<String> issn = entry.getField(StandardField.ISSN);
        if (issn.isPresent()) {
            Optional<JournalInformation> journalInformation = this.journalInformationFetcher.getJournalInformation(issn.get(), "");
            return journalInformation.map(journalInfo -> this.journalInformationToBibEntry((JournalInformation)journalInfo, (String)issn.get())).stream().toList();
        }
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return "ISSN";
    }

    @Override
    public Optional<BibEntry> performSearchById(String identifier) throws FetcherException {
        Optional<JournalInformation> journalInformation = this.journalInformationFetcher.getJournalInformation(identifier, "");
        return journalInformation.map(journalInfo -> this.journalInformationToBibEntry((JournalInformation)journalInfo, identifier));
    }

    private BibEntry journalInformationToBibEntry(JournalInformation journalInfo, String issn) {
        return new BibEntry().withField(StandardField.JOURNALTITLE, journalInfo.title()).withField(StandardField.PUBLISHER, journalInfo.publisher()).withField(StandardField.ISSN, issn);
    }
}

