/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import kong.unirest.core.GetRequest;
import kong.unirest.core.HttpResponse;
import kong.unirest.core.JsonNode;
import kong.unirest.core.Unirest;
import kong.unirest.core.UnirestException;
import kong.unirest.core.json.JSONObject;
import org.jabref.logic.importer.FulltextFetcher;
import org.jabref.logic.importer.ImporterPreferences;
import org.jabref.logic.importer.fetcher.CustomizableKeyFetcher;
import org.jabref.logic.importer.fetcher.TrustLevel;
import org.jabref.logic.util.BuildInfo;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.DOI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringerLink
implements FulltextFetcher,
CustomizableKeyFetcher {
    public static final String FETCHER_NAME = "Springer";
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringerLink.class);
    private static final String API_URL = "https://api.springer.com/meta/v1/json";
    private static final String API_KEY = new BuildInfo().springerNatureAPIKey;
    private static final String CONTENT_HOST = "link.springer.com";
    private final ImporterPreferences importerPreferences;

    public SpringerLink(ImporterPreferences importerPreferences) {
        this.importerPreferences = importerPreferences;
    }

    @Override
    public Optional<URL> findFullText(BibEntry entry) throws IOException {
        Objects.requireNonNull(entry);
        Optional doi = entry.getField(StandardField.DOI).flatMap(DOI::parse);
        if (doi.isEmpty()) {
            return Optional.empty();
        }
        try {
            JSONObject json;
            int results;
            HttpResponse jsonResponse = ((GetRequest)((GetRequest)Unirest.get((String)API_URL).queryString("api_key", (Object)this.importerPreferences.getApiKey(this.getName()).orElse(API_KEY))).queryString("q", (Object)"doi:%s".formatted(((DOI)doi.get()).getDOI()))).asJson();
            if (jsonResponse.getBody() != null && (results = (json = ((JsonNode)jsonResponse.getBody()).getObject()).getJSONArray("result").getJSONObject(0).getInt("total")) > 0) {
                LOGGER.info("Fulltext PDF found @ Springer.");
                return Optional.of(new URL("http", CONTENT_HOST, "/content/pdf/%s.pdf".formatted(((DOI)doi.get()).getDOI())));
            }
        }
        catch (UnirestException e) {
            LOGGER.warn("SpringerLink API request failed", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public TrustLevel getTrustLevel() {
        return TrustLevel.PUBLISHER;
    }

    @Override
    public String getName() {
        return FETCHER_NAME;
    }
}

