/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher.transformers;

import org.jabref.logic.importer.fetcher.transformers.YearAndYearRangeByFilteringQueryTransformer;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLPQueryTransformer
extends YearAndYearRangeByFilteringQueryTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBLPQueryTransformer.class);

    @Override
    protected String getLogicalAndOperator() {
        return " ";
    }

    @Override
    protected String getLogicalOrOperator() {
        return "|";
    }

    @Override
    protected String getLogicalNotOperator() {
        LOGGER.warn("DBLP does not support Boolean NOT operator.");
        return "";
    }

    @Override
    protected String handleAuthor(String author) {
        return StringUtil.quoteStringIfSpaceIsContained(author);
    }

    @Override
    protected String handleTitle(String title) {
        return StringUtil.quoteStringIfSpaceIsContained(title);
    }

    @Override
    protected String handleJournal(String journalTitle) {
        return StringUtil.quoteStringIfSpaceIsContained(journalTitle);
    }
}

