/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher.transformers;

import java.util.Optional;
import org.jabref.logic.importer.fetcher.transformers.AbstractQueryTransformer;

public class ZbMathQueryTransformer
extends AbstractQueryTransformer {
    @Override
    protected String getLogicalAndOperator() {
        return " & ";
    }

    @Override
    protected String getLogicalOrOperator() {
        return " | ";
    }

    @Override
    protected String getLogicalNotOperator() {
        return "!";
    }

    @Override
    protected String handleAuthor(String author) {
        return this.createKeyValuePair("au", author);
    }

    @Override
    protected String handleTitle(String title) {
        return this.createKeyValuePair("ti", title);
    }

    @Override
    protected String handleJournal(String journalTitle) {
        return this.createKeyValuePair("so", journalTitle);
    }

    @Override
    protected String handleYear(String year) {
        return "py:" + year;
    }

    @Override
    protected String handleYearRange(String yearRange) {
        return "py:" + yearRange;
    }

    @Override
    protected Optional<String> handleUnFieldedTerm(String term) {
        return Optional.of(this.createKeyValuePair("any", term));
    }
}

