/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jabref.logic.formatter.bibtexfields.HtmlToLatexFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizePagesFormatter;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fileformat.citavi.CitaviExchangeData;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Keyword;
import org.jabref.model.entry.KeywordList;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.IEEETranEntryType;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitaviXmlImporter
extends Importer
implements Parser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CitaviXmlImporter.class);
    private static final byte UUID_LENGTH = 36;
    private static final byte UUID_SEMICOLON_OFFSET_INDEX = 37;
    private static final EnumSet<QuotationTypeMapping> QUOTATION_TYPES = EnumSet.allOf(QuotationTypeMapping.class);
    private final HtmlToLatexFormatter htmlToLatexFormatter = new HtmlToLatexFormatter();
    private final NormalizePagesFormatter pagesFormatter = new NormalizePagesFormatter();
    private final Map<String, Author> knownPersons = new HashMap<String, Author>();
    private final Map<String, Keyword> knownKeywords = new HashMap<String, Keyword>();
    private final Map<String, String> knownPublishers = new HashMap<String, String>();
    private final XMLInputFactory xmlInputFactory;
    private Map<String, String> refIdWithAuthors = new HashMap<String, String>();
    private Map<String, String> refIdWithEditors = new HashMap<String, String>();
    private Map<String, String> refIdWithKeywords = new HashMap<String, String>();
    private Map<String, String> refIdWithPublishers = new HashMap<String, String>();
    private CitaviExchangeData.Persons persons;
    private CitaviExchangeData.Keywords keywords;
    private CitaviExchangeData.Publishers publishers;
    private CitaviExchangeData.KnowledgeItems knowledgeItems;
    private CitaviExchangeData.ReferenceAuthors refAuthors;
    private CitaviExchangeData.ReferenceEditors refEditors;
    private CitaviExchangeData.ReferenceKeywords refKeywords;
    private CitaviExchangeData.ReferencePublishers refPublishers;
    private Unmarshaller unmarshaller;

    public CitaviXmlImporter() {
        this.xmlInputFactory = XMLInputFactory.newFactory();
    }

    @Override
    public String getName() {
        return "Citavi XML";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.CITAVI;
    }

    @Override
    public String getId() {
        return "citavi";
    }

    @Override
    public String getDescription() {
        return "Importer for the Citavi XML format.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        Objects.requireNonNull(reader);
        return false;
    }

    @Override
    public boolean isRecognizedFormat(Path filePath) throws IOException {
        try (BufferedReader reader = this.getReaderFromZip(filePath);){
            String str;
            for (int i = 0; (str = reader.readLine()) != null && i < 50; ++i) {
                if (!str.toLowerCase(Locale.ROOT).contains("citaviexchangedata")) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ParserResult importDatabase(Path filePath) throws IOException {
        try (BufferedReader reader = this.getReaderFromZip(filePath);){
            Object unmarshalledObject = this.unmarshallRoot(reader);
            if (unmarshalledObject instanceof CitaviExchangeData) {
                CitaviExchangeData data = (CitaviExchangeData)unmarshalledObject;
                List<BibEntry> bibEntries = this.parseDataList(data);
                ParserResult parserResult2 = new ParserResult(bibEntries);
                return parserResult2;
            }
            ParserResult parserResult = ParserResult.fromErrorMessage("File does not start with xml tag.");
            return parserResult;
        }
        catch (JAXBException | XMLStreamException e) {
            LOGGER.debug("could not parse document", e);
            return ParserResult.fromError((Exception)e);
        }
    }

    private List<BibEntry> parseDataList(CitaviExchangeData data) {
        this.persons = data.getPersons();
        this.keywords = data.getKeywords();
        this.publishers = data.getPublishers();
        this.knowledgeItems = data.getKnowledgeItems();
        this.refAuthors = data.getReferenceAuthors();
        this.refEditors = data.getReferenceEditors();
        this.refKeywords = data.getReferenceKeywords();
        this.refPublishers = data.getReferencePublishers();
        if (this.refAuthors != null) {
            this.refIdWithAuthors = this.buildPersonList(this.refAuthors.getOnetoN());
        }
        if (this.refEditors != null) {
            this.refIdWithEditors = this.buildPersonList(this.refEditors.getOnetoN());
        }
        if (this.refKeywords != null) {
            this.refIdWithKeywords = this.buildKeywordList(this.refKeywords.getOnetoN());
        }
        if (this.refPublishers != null) {
            this.refIdWithPublishers = this.buildPublisherList(this.refPublishers.getOnetoN());
        }
        List<BibEntry> bibEntries = data.getReferences().getReference().stream().map(this::parseData).collect(Collectors.toList());
        return bibEntries;
    }

    private BibEntry parseData(CitaviExchangeData.References.Reference data) {
        BibEntry entry = new BibEntry();
        entry.setType(this.getType(data));
        Optional.ofNullable(data.getTitle()).ifPresent(value -> entry.setField(StandardField.TITLE, this.clean((String)value)));
        Optional.ofNullable(data.getAbstract()).ifPresent(value -> entry.setField(StandardField.ABSTRACT, this.clean((String)value)));
        Optional.ofNullable(data.getYear()).ifPresent(value -> entry.setField(StandardField.YEAR, this.clean((String)value)));
        Optional.ofNullable(data.getDoi()).ifPresent(value -> entry.setField(StandardField.DOI, this.clean((String)value)));
        Optional.ofNullable(data.getIsbn()).ifPresent(value -> entry.setField(StandardField.ISBN, this.clean((String)value)));
        String pages = this.clean(this.getPages(data));
        pages = this.pagesFormatter.format(pages);
        entry.setField(StandardField.PAGES, pages);
        Optional.ofNullable(data.getVolume()).ifPresent(value -> entry.setField(StandardField.VOLUME, this.clean((String)value)));
        Optional.ofNullable(this.getAuthorName(data)).ifPresent(value -> entry.setField(StandardField.AUTHOR, this.clean((String)value)));
        Optional.ofNullable(this.getEditorName(data)).ifPresent(value -> entry.setField(StandardField.EDITOR, this.clean((String)value)));
        Optional.ofNullable(this.getKeywords(data)).ifPresent(value -> entry.setField(StandardField.KEYWORDS, this.clean((String)value)));
        Optional.ofNullable(this.getPublisher(data)).ifPresent(value -> entry.setField(StandardField.PUBLISHER, this.clean((String)value)));
        Optional.ofNullable(this.getKnowledgeItem(data)).ifPresent(value -> entry.setField(StandardField.COMMENT, StringUtil.unifyLineBreaks(value, "\n")));
        return entry;
    }

    private EntryType getType(CitaviExchangeData.References.Reference data) {
        return Optional.ofNullable(data.getReferenceType()).map(CitaviXmlImporter::convertRefNameToType).orElse(StandardEntryType.Article);
    }

    private static EntryType convertRefNameToType(String refName) {
        return switch (refName.toLowerCase().trim()) {
            case "artwork", "generic", "musicalbum", "audioorvideodocument", "movie" -> StandardEntryType.Misc;
            case "electronic article" -> IEEETranEntryType.Electronic;
            case "book section" -> StandardEntryType.InBook;
            case "book", "bookedited", "audiobook" -> StandardEntryType.Book;
            case "report" -> StandardEntryType.Report;
            default -> StandardEntryType.Article;
        };
    }

    private String getPages(CitaviExchangeData.References.Reference data) {
        String tmpStr = "";
        if (data.getPageCount() != null && data.getPageRange() == null) {
            tmpStr = data.getPageCount();
        } else if (data.getPageCount() == null && data.getPageRange() != null) {
            tmpStr = data.getPageRange();
        } else if (data.getPageCount() == null && data.getPageRange() == null) {
            return tmpStr;
        }
        int count = 0;
        String pages = "";
        for (int i = tmpStr.length() - 1; i >= 0; --i) {
            if (count == 2) {
                pages = tmpStr.substring(i + 2, tmpStr.length() - 1 - 5 + 1);
                break;
            }
            if (tmpStr.charAt(i) != '>') continue;
            ++count;
        }
        return pages;
    }

    private String getAuthorName(CitaviExchangeData.References.Reference data) {
        if (this.refAuthors == null) {
            return null;
        }
        return this.refIdWithAuthors.get(data.getId());
    }

    private Map<String, String> buildPersonList(List<String> authorsOrEditors) {
        HashMap<String, String> refToPerson = new HashMap<String, String>();
        for (String idStringsWithSemicolon : authorsOrEditors) {
            String refId = idStringsWithSemicolon.substring(0, 36);
            String rest = idStringsWithSemicolon.substring(37);
            String[] personIds = rest.split(";");
            ArrayList<Author> jabrefAuthors = new ArrayList<Author>();
            for (String personId : personIds) {
                this.knownPersons.computeIfAbsent(personId, k -> {
                    Optional<CitaviExchangeData.Persons.Person> person = this.persons.getPerson().stream().filter(p -> p.getId().equals(k)).findFirst();
                    return person.map(p -> new Author(p.getFirstName(), "", "", p.getLastName(), "")).orElse(null);
                });
                jabrefAuthors.add(this.knownPersons.get(personId));
            }
            String stringifiedAuthors = AuthorList.of(jabrefAuthors).getAsLastFirstNamesWithAnd(false);
            refToPerson.put(refId, stringifiedAuthors);
        }
        return refToPerson;
    }

    private Map<String, String> buildKeywordList(List<String> keywordsList) {
        HashMap<String, String> refToKeywords = new HashMap<String, String>();
        for (String idStringsWithSemicolon : keywordsList) {
            String refId = idStringsWithSemicolon.substring(0, 36);
            String rest = idStringsWithSemicolon.substring(37);
            String[] keywordIds = rest.split(";");
            ArrayList<Keyword> jabrefKeywords = new ArrayList<Keyword>();
            for (String keywordId : keywordIds) {
                this.knownKeywords.computeIfAbsent(keywordId, k -> {
                    Optional<CitaviExchangeData.Keywords.Keyword> keyword = this.keywords.getKeyword().stream().filter(p -> p.getId().equals(k)).findFirst();
                    return keyword.map(kword -> new Keyword(kword.getName())).orElse(null);
                });
                jabrefKeywords.add(this.knownKeywords.get(keywordId));
            }
            KeywordList list = new KeywordList((Collection<Keyword>)List.copyOf(jabrefKeywords));
            String stringifiedKeywords = list.toString();
            refToKeywords.put(refId, stringifiedKeywords);
        }
        return refToKeywords;
    }

    private Map<String, String> buildPublisherList(List<String> publishersList) {
        HashMap<String, String> refToPublishers = new HashMap<String, String>();
        for (String idStringsWithSemicolon : publishersList) {
            String refId = idStringsWithSemicolon.substring(0, 36);
            String rest = idStringsWithSemicolon.substring(37);
            String[] publisherIds = rest.split(";");
            ArrayList<String> jabrefPublishers = new ArrayList<String>();
            for (String pubId : publisherIds) {
                this.knownPublishers.computeIfAbsent(pubId, k -> {
                    Optional<CitaviExchangeData.Publishers.Publisher> publisher = this.publishers.getPublisher().stream().filter(p -> p.getId().equals(k)).findFirst();
                    return publisher.map(CitaviExchangeData.Publishers.Publisher::getName).orElse(null);
                });
                jabrefPublishers.add(this.knownPublishers.get(pubId));
            }
            String stringifiedKeywords = String.join((CharSequence)",", jabrefPublishers);
            refToPublishers.put(refId, stringifiedKeywords);
        }
        return refToPublishers;
    }

    private String getEditorName(CitaviExchangeData.References.Reference data) {
        if (this.refEditors == null) {
            return null;
        }
        return this.refIdWithEditors.get(data.getId());
    }

    private String getKeywords(CitaviExchangeData.References.Reference data) {
        if (this.refKeywords == null) {
            return null;
        }
        return this.refIdWithKeywords.get(data.getId());
    }

    private String getPublisher(CitaviExchangeData.References.Reference data) {
        if (this.refPublishers == null) {
            return null;
        }
        return this.refIdWithPublishers.get(data.getId());
    }

    private String getKnowledgeItem(CitaviExchangeData.References.Reference data) {
        StringJoiner comment = new StringJoiner("\n\n");
        List<CitaviExchangeData.KnowledgeItems.KnowledgeItem> foundItems = this.knowledgeItems.getKnowledgeItem().stream().filter(p -> data.getId().equals(p.getReferenceID())).toList();
        for (CitaviExchangeData.KnowledgeItems.KnowledgeItem knowledgeItem : foundItems) {
            Optional<String> title = Optional.ofNullable(knowledgeItem.getCoreStatement()).filter(Predicate.not(String::isEmpty));
            title.ifPresent(t -> comment.add("# " + this.cleanUpText((String)t)));
            Optional<String> text = Optional.ofNullable(knowledgeItem.getText()).filter(Predicate.not(String::isEmpty));
            text.ifPresent(t -> comment.add(this.cleanUpText((String)t)));
            Optional<Integer> pages = Optional.of(knowledgeItem.getPageRangeNumber()).filter(range -> range != -1);
            pages.ifPresent(p -> comment.add("page range: " + p));
            Optional quotationTypeDesc = Optional.of(knowledgeItem.getQuotationType()).flatMap(type -> QUOTATION_TYPES.stream().filter(qt -> type.shortValue() == qt.getCitaviIndexType()).map(QuotationTypeMapping::getName).findFirst());
            quotationTypeDesc.ifPresent(qt -> comment.add("quotation type: %s".formatted(qt)));
            Optional<Short> quotationIndex = Optional.of(knowledgeItem.getQuotationIndex());
            quotationIndex.ifPresent(index -> comment.add("quotation index: %d".formatted(index)));
        }
        return comment.toString();
    }

    String cleanUpText(String text) {
        String result = this.removeSpacesBeforeLineBreak(text);
        result = result.replaceAll("(?<!\\\\)\\{", "\\\\{");
        result = result.replaceAll("(?<!\\\\)}", "\\\\}");
        return result;
    }

    private String removeSpacesBeforeLineBreak(String string) {
        return string.replaceAll(" +\r\n", "\r\n").replaceAll(" +\n", "\n");
    }

    private void initUnmarshaller() throws JAXBException {
        if (this.unmarshaller == null) {
            JAXBContext context = JAXBContext.newInstance((String)"org.jabref.logic.importer.fileformat.citavi");
            this.unmarshaller = context.createUnmarshaller();
        }
    }

    private Object unmarshallRoot(BufferedReader reader) throws XMLStreamException, JAXBException {
        this.initUnmarshaller();
        XMLStreamReader xmlStreamReader = this.xmlInputFactory.createXMLStreamReader(reader);
        while (!xmlStreamReader.isStartElement()) {
            xmlStreamReader.next();
        }
        return this.unmarshaller.unmarshal(xmlStreamReader);
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        Objects.requireNonNull(reader);
        throw new UnsupportedOperationException("CitaviXmlImporter does not support importDatabase(BufferedReader reader).Instead use importDatabase(Path filePath, Charset defaultEncoding).");
    }

    @Override
    public List<BibEntry> parseEntries(InputStream inputStream) {
        try {
            return this.importDatabase(new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8))).getDatabase().getEntries();
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private BufferedReader getReaderFromZip(Path filePath) throws IOException {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(filePath.toFile()));
        ZipEntry zipEntry = zis.getNextEntry();
        Path newFile = Files.createTempFile("citavicontent", ".xml", new FileAttribute[0]);
        while (zipEntry != null) {
            Files.copy(zis, newFile, StandardCopyOption.REPLACE_EXISTING);
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        InputStream stream = Files.newInputStream(newFile, StandardOpenOption.READ);
        InputStream newStream = CitaviXmlImporter.checkForUtf8BOMAndDiscardIfAny(stream);
        Files.delete(newFile);
        return new BufferedReader(new InputStreamReader(newStream, StandardCharsets.UTF_8));
    }

    private static InputStream checkForUtf8BOMAndDiscardIfAny(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(new BufferedInputStream(inputStream), 3);
        byte[] bom = new byte[3];
        if (pushbackInputStream.read(bom) != -1 && (bom[0] != -17 || bom[1] != -69 || bom[2] != -65)) {
            pushbackInputStream.unread(bom);
        }
        return pushbackInputStream;
    }

    private String clean(String input) {
        String result = StringUtil.unifyLineBreaks(input, " ").trim().replaceAll(" +", " ");
        return this.htmlToLatexFormatter.format(result);
    }

    static enum QuotationTypeMapping {
        IMAGE_QUOTATION(0, "Image quotation"),
        DIRECT_QUOTATION(1, "Direct quotation"),
        INDIRECT_QUOTATION(2, "Indirect quotation"),
        SUMMARY(3, "Summary"),
        COMMENT(4, "Comment"),
        HIGHLIGHT(5, "Highlight"),
        HIGHLIGHT_RED(6, "Highlight in red");

        final int citaviType;
        final String name;

        private QuotationTypeMapping(int citaviType, String name) {
            this.name = name;
            this.citaviType = citaviType;
        }

        String getName() {
            return this.name;
        }

        int getCitaviIndexType() {
            return this.citaviType;
        }
    }
}

