/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedSet;
import javafx.collections.ObservableList;
import org.jabref.logic.importer.EntryBasedFetcher;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fetcher.DoiFetcher;
import org.jabref.logic.importer.fetcher.isbntobibtex.IsbnFetcher;
import org.jabref.logic.importer.fileformat.PdfContentImporter;
import org.jabref.logic.importer.fileformat.PdfEmbeddedBibFileImporter;
import org.jabref.logic.importer.fileformat.PdfGrobidImporter;
import org.jabref.logic.importer.fileformat.PdfVerbatimBibTextImporter;
import org.jabref.logic.importer.fileformat.PdfXmpImporter;
import org.jabref.logic.importer.util.FileFieldParser;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.FilePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfMergeMetadataImporter
extends Importer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfMergeMetadataImporter.class);
    private final List<Importer> metadataImporters;
    private final ImportFormatPreferences importFormatPreferences;

    public PdfMergeMetadataImporter(ImportFormatPreferences importFormatPreferences) {
        this.importFormatPreferences = importFormatPreferences;
        this.metadataImporters = new ArrayList<Importer>();
        this.metadataImporters.add(new PdfVerbatimBibTextImporter(importFormatPreferences));
        this.metadataImporters.add(new PdfEmbeddedBibFileImporter(importFormatPreferences));
        if (importFormatPreferences.grobidPreferences().isGrobidEnabled()) {
            this.metadataImporters.add(new PdfGrobidImporter(importFormatPreferences));
        }
        this.metadataImporters.add(new PdfXmpImporter(importFormatPreferences.xmpPreferences()));
        this.metadataImporters.add(new PdfContentImporter());
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader input) throws IOException {
        return input.readLine().startsWith("%PDF");
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        Objects.requireNonNull(reader);
        throw new UnsupportedOperationException("PdfMergeMetadataImporter does not support importDatabase(BufferedReader reader).Instead use importDatabase(Path filePath, Charset defaultEncoding).");
    }

    @Override
    public ParserResult importDatabase(String data) throws IOException {
        Objects.requireNonNull(data);
        throw new UnsupportedOperationException("PdfMergeMetadataImporter does not support importDatabase(String data).Instead use importDatabase(Path filePath, Charset defaultEncoding).");
    }

    @Override
    public ParserResult importDatabase(Path filePath) throws IOException {
        ArrayList<BibEntry> candidates = new ArrayList<BibEntry>();
        for (Importer importer : this.metadataImporters) {
            ObservableList<BibEntry> extractedEntries = importer.importDatabase(filePath).getDatabase().getEntries();
            if (extractedEntries.isEmpty()) continue;
            candidates.add((BibEntry)extractedEntries.getFirst());
        }
        if (candidates.isEmpty()) {
            return new ParserResult();
        }
        ArrayList fetchedCandidates = new ArrayList();
        for (BibEntry candidate : candidates) {
            if (candidate.hasField(StandardField.DOI)) {
                try {
                    new DoiFetcher(this.importFormatPreferences).performSearchById(candidate.getField(StandardField.DOI).get()).ifPresent(fetchedCandidates::add);
                }
                catch (FetcherException e) {
                    LOGGER.error("Fetching failed for DOI \"{}\".", (Object)candidate.getField(StandardField.DOI).get(), (Object)e);
                }
            }
            if (!candidate.hasField(StandardField.ISBN)) continue;
            try {
                new IsbnFetcher(this.importFormatPreferences).performSearchById(candidate.getField(StandardField.ISBN).get()).ifPresent(fetchedCandidates::add);
            }
            catch (FetcherException e) {
                LOGGER.error("Fetching failed for ISBN \"{}\".", (Object)candidate.getField(StandardField.ISBN).get(), (Object)e);
            }
        }
        candidates.addAll(0, fetchedCandidates);
        BibEntry bibEntry = new BibEntry();
        for (BibEntry candidate : candidates) {
            if (BibEntry.DEFAULT_TYPE.equals(bibEntry.getType())) {
                bibEntry.setType(candidate.getType());
            }
            SequencedSet<Field> presentFields = bibEntry.getFields();
            for (Map.Entry<Field, String> fieldEntry : candidate.getFieldMap().entrySet()) {
                if (StandardField.FILE == fieldEntry.getKey() && FileFieldParser.parse(fieldEntry.getValue()).stream().noneMatch(LinkedFile::isOnlineLink) || presentFields.contains(fieldEntry.getKey())) continue;
                bibEntry.setField(fieldEntry.getKey(), fieldEntry.getValue());
            }
        }
        bibEntry.addFile(new LinkedFile("", filePath, StandardFileType.PDF.getName()));
        return new ParserResult(List.of(bibEntry));
    }

    @Override
    public String getName() {
        return "PDFmergemetadata";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.PDF;
    }

    @Override
    public String getDescription() {
        return "PdfMergeMetadataImporter imports metadata from a PDF using multiple strategies and merging the result.";
    }

    public static class EntryBasedFetcherWrapper
    extends PdfMergeMetadataImporter
    implements EntryBasedFetcher {
        private static final Logger LOGGER = LoggerFactory.getLogger(EntryBasedFetcherWrapper.class);
        private final FilePreferences filePreferences;
        private final BibDatabaseContext databaseContext;

        public EntryBasedFetcherWrapper(ImportFormatPreferences importFormatPreferences, FilePreferences filePreferences, BibDatabaseContext context) {
            super(importFormatPreferences);
            this.filePreferences = filePreferences;
            this.databaseContext = context;
        }

        @Override
        public List<BibEntry> performSearch(BibEntry entry) throws FetcherException {
            for (LinkedFile file : entry.getFiles()) {
                Optional<Path> filePath = file.findIn(this.databaseContext, this.filePreferences);
                if (!filePath.isPresent()) continue;
                try {
                    ParserResult result = this.importDatabase(filePath.get());
                    if (result.isEmpty()) continue;
                    return result.getDatabase().getEntries();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot read {}", (Object)filePath.get(), (Object)e);
                }
            }
            return List.of();
        }
    }
}

