/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.EntryTypeFactory;
import org.jabref.model.entry.types.StandardEntryType;

public class SilverPlatterImporter
extends Importer {
    private static final Pattern START_PATTERN = Pattern.compile("Record.*INSPEC.*");

    @Override
    public String getName() {
        return "SilverPlatter";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.SILVER_PLATTER;
    }

    @Override
    public String getDescription() {
        return "Imports a SilverPlatter exported file.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        while ((str = reader.readLine()) != null) {
            if (START_PATTERN.matcher(str).find()) {
                return false;
            }
            if (str.length() < 5 || !"TI:  ".equals(str.substring(0, 5))) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String str;
        ArrayList<BibEntry> bibitems = new ArrayList<BibEntry>();
        boolean isChapter = false;
        StringBuilder sb = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            if (str.length() < 2) {
                sb.append("__::__").append(str);
                continue;
            }
            sb.append("__NEWFIELD__").append(str);
        }
        String[] entries = sb.toString().split("__::__");
        EntryType type = StandardEntryType.Misc;
        HashMap<Field, String> h = new HashMap<Field, String>();
        for (String entry : entries) {
            String title;
            int inPos;
            String titleO;
            String[] fields;
            if (entry.trim().length() < 6) continue;
            h.clear();
            block24: for (String field : fields = entry.split("__NEWFIELD__")) {
                if (field.length() < 6) continue;
                String f3 = field.substring(0, 2);
                String frest = field.substring(5);
                switch (f3) {
                    case "TI": {
                        h.put(StandardField.TITLE, frest);
                        continue block24;
                    }
                    case "AU": {
                        if (frest.trim().endsWith("(ed)")) {
                            String ed = frest.trim();
                            ed = ed.substring(0, ed.length() - 4);
                            h.put(StandardField.EDITOR, AuthorList.fixAuthorLastNameFirst(ed.replace(",-", ", ").replace(";", " and ")));
                            continue block24;
                        }
                        h.put(StandardField.AUTHOR, AuthorList.fixAuthorLastNameFirst(frest.replace(",-", ", ").replace(";", " and ")));
                        continue block24;
                    }
                    case "AB": {
                        h.put(StandardField.ABSTRACT, frest);
                        continue block24;
                    }
                    case "DE": {
                        String kw = frest.replace("-;", ",").toLowerCase(Locale.ROOT);
                        h.put(StandardField.KEYWORDS, kw.substring(0, kw.length() - 1));
                        continue block24;
                    }
                    case "SO": {
                        int m = frest.indexOf(46);
                        if (m < 0) continue block24;
                        String jr = frest.substring(0, m);
                        h.put(StandardField.JOURNAL, jr.replace("-", " "));
                        frest = frest.substring(m);
                        m = frest.indexOf(59);
                        if (m < 5) continue block24;
                        String yr = frest.substring(m - 5, m).trim();
                        h.put(StandardField.YEAR, yr);
                        frest = frest.substring(m);
                        m = frest.indexOf(58);
                        int issueIndex = frest.indexOf(40);
                        int endIssueIndex = frest.indexOf(41);
                        if (m < 0) continue block24;
                        String pg = frest.substring(m + 1).trim();
                        h.put(StandardField.PAGES, pg);
                        h.put(StandardField.VOLUME, frest.substring(1, issueIndex).trim());
                        h.put(StandardField.ISSUE, frest.substring(issueIndex + 1, endIssueIndex).trim());
                        continue block24;
                    }
                    case "PB": {
                        int m = frest.indexOf(58);
                        if (m < 0) continue block24;
                        String jr = frest.substring(0, m);
                        h.put(StandardField.PUBLISHER, jr.replace("-", " ").trim());
                        frest = frest.substring(m);
                        m = frest.indexOf(", ");
                        if (m + 2 >= frest.length()) continue block24;
                        String yr = frest.substring(m + 2).trim();
                        try {
                            Integer.parseInt(yr);
                            h.put(StandardField.YEAR, yr);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue block24;
                    }
                    case "AF": {
                        h.put(StandardField.SCHOOL, frest.trim());
                        continue block24;
                    }
                    case "DT": {
                        frest = frest.trim();
                        if ("Monograph".equals(frest)) {
                            type = StandardEntryType.Book;
                            continue block24;
                        }
                        if (frest.startsWith("Dissertation")) {
                            type = StandardEntryType.PhdThesis;
                            continue block24;
                        }
                        if (frest.toLowerCase(Locale.ROOT).contains(StandardField.JOURNAL.getName())) {
                            type = StandardEntryType.Article;
                            continue block24;
                        }
                        if ("Contribution".equals(frest) || "Chapter".equals(frest)) {
                            type = StandardEntryType.InCollection;
                            isChapter = true;
                            continue block24;
                        }
                        type = EntryTypeFactory.parse(frest.replace(" ", ""));
                    }
                }
            }
            if (isChapter && (titleO = (String)h.get(StandardField.TITLE)) != null && (inPos = (title = titleO.trim()).indexOf("\" in ")) > 1) {
                h.put(StandardField.TITLE, title.substring(0, inPos));
            }
            BibEntry b = new BibEntry(type);
            b.setField(h);
            bibitems.add(b);
        }
        return new ParserResult(bibitems);
    }
}

