/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jabref.logic.importer.util.StaxParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MathMLParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MathMLParser.class);
    private static final String XSLT_FILE_PATH = "/xslt/mathml_latex/mmltex.xsl";

    public static String parse(XMLStreamReader reader) {
        String xmlContent = "";
        String latexResult = "<Unsupported MathML expression>";
        try {
            xmlContent = StaxParser.getXMLContent(reader);
            StreamSource xmlSource = new StreamSource(new StringReader(xmlContent));
            URL xsltResource = MathMLParser.class.getResource(XSLT_FILE_PATH);
            StreamSource xsltSource = new StreamSource(Objects.requireNonNull(xsltResource).openStream(), xsltResource.toURI().toASCIIString());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(xsltSource);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(xmlSource, result);
            latexResult = writer.getBuffer().toString();
        }
        catch (XMLStreamException e) {
            LOGGER.debug("An exception occurred when getting XML content", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.debug("An I/O exception occurred", (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOGGER.debug("XSLT Source URI invalid", (Throwable)e);
        }
        catch (TransformerException e) {
            LOGGER.debug("An exception occurred during transformation", (Throwable)e);
        }
        return latexResult;
    }
}

