/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import org.jabref.logic.integrity.DatabaseChecker;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.DOI;

public class DoiDuplicationChecker
implements DatabaseChecker {
    @Override
    public List<IntegrityMessage> check(BibDatabase database) {
        ObservableList<BibEntry> bibEntries = database.getEntries();
        HashBiMap duplicateMap = HashBiMap.create((int)bibEntries.size());
        for (BibEntry bibEntry : bibEntries) {
            bibEntry.getDOI().ifPresent(arg_0 -> DoiDuplicationChecker.lambda$check$1((BiMap)duplicateMap, bibEntry, arg_0));
        }
        return duplicateMap.inverse().keySet().stream().filter(list -> list.size() > 1).flatMap(list -> list.stream()).map(item -> new IntegrityMessage(Localization.lang("Same DOI used in multiple entries", new Object[0]), (BibEntry)item, StandardField.DOI)).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$check$1(BiMap duplicateMap, BibEntry bibEntry, DOI doi) {
        ((List)duplicateMap.computeIfAbsent((Object)doi, absentDoi -> new ArrayList())).add(bibEntry);
    }
}

