/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.journals;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.csv.CSVPrinter;
import org.jabref.logic.journals.Abbreviation;
import org.jabref.logic.journals.AbbreviationFormat;

public final class AbbreviationWriter {
    private AbbreviationWriter() {
    }

    public static void writeOrCreate(Path path, List<Abbreviation> abbreviations) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.UTF_8);
             CSVPrinter csvPrinter = new CSVPrinter((Appendable)writer, AbbreviationFormat.getCSVFormatWithDefaultDilimeter());){
            for (Abbreviation entry : abbreviations) {
                if (entry.isDefaultShortestUniqueAbbreviation()) {
                    csvPrinter.printRecord(new Object[]{entry.getName(), entry.getAbbreviation()});
                    continue;
                }
                csvPrinter.printRecord(new Object[]{entry.getName(), entry.getAbbreviation(), entry.getShortestUniqueAbbreviation()});
            }
        }
    }
}

