/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.l10n;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public enum Language {
    ARABIC("\u0627\u0644\u0639\u0631\u0628\u064a\u0629 (Arabic)", "ar"),
    BAHASA_INDONESIA("Bahasa Indonesia", "id"),
    BRAZILIAN_PORTUGUESE("Brazilian Portuguese", "pt_BR"),
    DANISH("Dansk", "da"),
    DUTCH("Nederlands", "nl"),
    ENGLISH("English", "en"),
    FINNISH("Suomi", "fi"),
    FRENCH("Fran\u00e7ais", "fr"),
    GERMAN("Deutsch", "de"),
    GREEK("\u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac (Greek)", "el"),
    ITALIAN("Italiano", "it"),
    JAPANESE("Japanese", "ja"),
    KOREAN("\ud55c\uad6d\uc5b4 (Korean)", "ko"),
    NORWEGIAN("Norsk", "no"),
    PERSIAN("\u0641\u0627\u0631\u0633\u06cc (Farsi)", "fa"),
    POLISH("Polish", "pl"),
    PORTUGUESE("Portugu\u00eas", "pt"),
    RUSSIAN("Russian", "ru"),
    SIMPLIFIED_CHINESE("Chinese (Simplified)", "zh_CN"),
    SPANISH("Espa\u00f1ol", "es"),
    SWEDISH("Svenska", "sv"),
    TAGALOG("Tagalog/Filipino", "tl"),
    TRADITIONAL_CHINESE("Chinese (Traditional)", "zh_TW"),
    TURKISH("Turkish", "tr"),
    UKRAINIAN("\u0443\u043a\u0440\u0430\u0457\u0301\u043d\u0441\u044c\u043a\u0430 (Ukrainian)", "uk"),
    VIETNAMESE("Vietnamese", "vi");

    private static final Pattern IS_NOT_LATIN;
    private final String displayName;
    private final String id;

    private Language(String displayName, String id) {
        this.displayName = displayName;
        this.id = id;
    }

    public static Optional<Locale> convertToSupportedLocale(Language language) {
        Objects.requireNonNull(language);
        String[] languageParts = language.getId().split("_");
        Locale locale = languageParts.length == 1 ? Locale.of(languageParts[0]) : (languageParts.length == 2 ? Locale.of(languageParts[0], languageParts[1]) : Locale.ENGLISH);
        return Optional.of(locale);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public static List<Language> getSorted() {
        return Arrays.stream(Language.values()).sorted(Comparator.comparing(language -> Language.removeNonLatinCharacters(language.getDisplayName()))).toList();
    }

    private static String removeNonLatinCharacters(String input) {
        return IS_NOT_LATIN.matcher(input).replaceAll("");
    }

    static {
        IS_NOT_LATIN = Pattern.compile("[^\\p{IsLatin}]");
    }
}

