/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.l10n;

import java.util.Objects;

public class LocalizationKey {
    private final String key;
    private final String escapedPropertyKey;

    private LocalizationKey(String key) {
        this.key = key;
        this.escapedPropertyKey = key.replace("\n", "\\n").replace(" ", "\\ ").replace("#", "\\#").replace("!", "\\!").replace("=", "\\=").replace(":", "\\:");
    }

    public static LocalizationKey fromKey(String key) {
        return new LocalizationKey(Objects.requireNonNull(key));
    }

    public static LocalizationKey fromEscapedJavaString(String key) {
        return new LocalizationKey(Objects.requireNonNull(key));
    }

    public String getEscapedPropertiesKey() {
        return this.escapedPropertyKey;
    }

    public String getValueForEnglishPropertiesFile() {
        return this.key.replace("\n", "\\n");
    }

    public String getKey() {
        return this.key;
    }
}

