/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout.format;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.util.Objects;
import org.jabref.logic.layout.LayoutFormatter;

public class MarkdownFormatter
implements LayoutFormatter {
    private final Parser parser;
    private final HtmlRenderer renderer;

    public MarkdownFormatter() {
        MutableDataSet options = new MutableDataSet();
        this.parser = Parser.builder((DataHolder)options).build();
        this.renderer = HtmlRenderer.builder((DataHolder)options).build();
    }

    @Override
    public String format(String fieldText) {
        Objects.requireNonNull(fieldText, "Field Text should not be null, when handed to formatter");
        Document document = this.parser.parse(fieldText);
        String html = this.renderer.render((Node)document);
        return html.replaceAll("\\r\\n|\\r|\\n", " ").trim();
    }
}

