/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout.format;

import org.jabref.logic.layout.LayoutFormatter;

public class RemoveLatexCommandsFormatter
implements LayoutFormatter {
    @Override
    public String format(String field) {
        StringBuilder cleanedField = new StringBuilder();
        StringBuilder currentCommand = null;
        boolean escaped = false;
        boolean incommand = false;
        for (int currentFieldPosition = 0; currentFieldPosition < field.length(); ++currentFieldPosition) {
            char currentCharacter = field.charAt(currentFieldPosition);
            if (escaped && currentCharacter == '\\') {
                cleanedField.append('\\');
                escaped = false;
                incommand = false;
                continue;
            }
            if (currentCharacter == '\\') {
                escaped = true;
                incommand = true;
                currentCommand = new StringBuilder();
                continue;
            }
            if (!incommand && (currentCharacter == '{' || currentCharacter == '}')) continue;
            if (Character.isLetter(currentCharacter) || "\"`^~'=.|".contains(String.valueOf(currentCharacter))) {
                escaped = false;
                if (incommand) {
                    currentCommand.append(currentCharacter);
                    if (currentCommand.length() != 1 || !"\"`^~'=.|".contains(currentCommand.toString())) continue;
                    incommand = false;
                    escaped = false;
                    continue;
                }
                cleanedField.append(currentCharacter);
                continue;
            }
            if (Character.isLetter(currentCharacter)) {
                escaped = false;
                if (incommand) {
                    currentCommand.append(currentCharacter);
                    continue;
                }
                cleanedField.append(currentCharacter);
                continue;
            }
            if (!incommand || !Character.isWhitespace(currentCharacter) && currentCharacter != '{') {
                cleanedField.append(currentCharacter);
            } else {
                if (!Character.isWhitespace(currentCharacter) && currentCharacter != '{') {
                    cleanedField.append(currentCharacter);
                }
                if (incommand) {
                    while (currentFieldPosition + 1 < field.length() && Character.isWhitespace(field.charAt(currentFieldPosition + 1))) {
                        ++currentFieldPosition;
                    }
                }
            }
            incommand = false;
            escaped = false;
        }
        return cleanedField.toString();
    }
}

