/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.net;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kong.unirest.core.Unirest;
import kong.unirest.core.UnirestException;
import org.jabref.logic.importer.FetcherClientException;
import org.jabref.logic.importer.FetcherServerException;
import org.jabref.logic.net.ProgressInputStream;
import org.jabref.logic.util.io.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLDownload {
    public static final String USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36";
    private static final Logger LOGGER = LoggerFactory.getLogger(URLDownload.class);
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(30L);
    private final URL source;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private String postData = "";
    private Duration connectTimeout = DEFAULT_CONNECT_TIMEOUT;

    public URLDownload(String source) throws MalformedURLException {
        this(new URL(source));
    }

    public URLDownload(URL source) {
        this.source = source;
        this.addHeader("User-Agent", USER_AGENT);
    }

    @Deprecated
    public static void bypassSSLVerification() {
        LOGGER.warn("Fix SSL exceptions by accepting ALL certificates");
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
            HostnameVerifier allHostsValid = (hostname, session) -> true;
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (Exception e) {
            LOGGER.error("A problem occurred when bypassing SSL verification", (Throwable)e);
        }
    }

    public static void setSSLVerification(SSLSocketFactory socketFactory, HostnameVerifier verifier) {
        try {
            HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
            HttpsURLConnection.setDefaultHostnameVerifier(verifier);
        }
        catch (Exception e) {
            LOGGER.error("A problem occurred when reset SSL verification", (Throwable)e);
        }
    }

    public URL getSource() {
        return this.source;
    }

    public String getMimeType() {
        String contentType;
        Unirest.config().setDefaultHeader("User-Agent", "Mozilla/5.0 (Windows; U; WindowsNT 5.1; en-US; rv1.8.1.6) Gecko/20070725 Firefox/2.0.0.6");
        try {
            contentType = (String)Unirest.head((String)this.source.toString()).asString().getHeaders().get("Content-Type").getFirst();
            if (contentType != null && !contentType.isEmpty()) {
                return contentType;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error getting MIME type of URL via HEAD request", (Throwable)e);
        }
        try {
            contentType = (String)Unirest.get((String)this.source.toString()).asString().getHeaders().get("Content-Type").getFirst();
            if (contentType != null && !contentType.isEmpty()) {
                return contentType;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error getting MIME type of URL via GET request", (Throwable)e);
        }
        try {
            URLConnection connection = new URL(this.source.toString()).openConnection();
            contentType = connection.getContentType();
            if (contentType != null && !contentType.isEmpty()) {
                return contentType;
            }
        }
        catch (IOException e) {
            LOGGER.debug("Error trying to get MIME type of local URI", (Throwable)e);
        }
        return "";
    }

    public boolean canBeReached() throws UnirestException {
        Unirest.config().reset().followRedirects(true).enableCookieManagement(true).setDefaultHeader("User-Agent", USER_AGENT);
        int statusCode = Unirest.head((String)this.source.toString()).asString().getStatus();
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean isMimeType(String type) {
        String mime = this.getMimeType();
        if (mime.isEmpty()) {
            return false;
        }
        return mime.startsWith(type);
    }

    public boolean isPdf() {
        return this.isMimeType("application/pdf");
    }

    public void addHeader(String key, String value) {
        this.parameters.put(key, value);
    }

    public void setPostData(String postData) {
        if (postData != null) {
            this.postData = postData;
        }
    }

    public String asString() throws IOException {
        return URLDownload.asString(StandardCharsets.UTF_8, this.openConnection());
    }

    public String asString(Charset encoding) throws IOException {
        return URLDownload.asString(encoding, this.openConnection());
    }

    public static String asString(URLConnection existingConnection) throws IOException {
        return URLDownload.asString(StandardCharsets.UTF_8, existingConnection);
    }

    public static String asString(Charset encoding, URLConnection connection) throws IOException {
        try (BufferedInputStream input = new BufferedInputStream(connection.getInputStream());){
            String string;
            try (StringWriter output = new StringWriter();){
                URLDownload.copy(input, output, encoding);
                string = ((Object)output).toString();
            }
            return string;
        }
    }

    public List<HttpCookie> getCookieFromUrl() throws IOException {
        CookieManager cookieManager = new CookieManager();
        CookieHandler.setDefault(cookieManager);
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        URLConnection con = this.openConnection();
        con.getHeaderFields();
        try {
            return cookieManager.getCookieStore().get(this.source.toURI());
        }
        catch (URISyntaxException e) {
            LOGGER.error("Unable to convert download URL to URI", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void toFile(Path destination) throws IOException {
        try (BufferedInputStream input = new BufferedInputStream(this.openConnection().getInputStream());){
            Files.copy(input, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.warn("Could not copy input", (Throwable)e);
            throw e;
        }
    }

    public ProgressInputStream asInputStream() throws IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)this.openConnection();
        if (urlConnection.getResponseCode() == 404 || urlConnection.getResponseCode() == 400) {
            LOGGER.error("Response message {} returned for url {}", (Object)urlConnection.getResponseMessage(), (Object)urlConnection.getURL());
            return new ProgressInputStream(new ByteArrayInputStream(new byte[0]), 0L);
        }
        long fileSize = urlConnection.getContentLengthLong();
        return new ProgressInputStream(new BufferedInputStream(urlConnection.getInputStream()), fileSize);
    }

    public Path toTemporaryFile() throws IOException {
        String sourcePath = this.source.getPath();
        String fileNameWithExtension = sourcePath.substring(sourcePath.lastIndexOf(47) + 1);
        String fileName = "jabref-" + FileUtil.getBaseName(fileNameWithExtension);
        String extension = "." + FileUtil.getFileExtension(fileNameWithExtension).orElse("tmp");
        Path file = Files.createTempFile(fileName, extension, new FileAttribute[0]);
        file.toFile().deleteOnExit();
        this.toFile(file);
        return file;
    }

    public String toString() {
        return "URLDownload{source=" + String.valueOf(this.source) + "}";
    }

    private static void copy(InputStream in, Writer out, Charset encoding) throws IOException {
        InputStreamReader r = new InputStreamReader(in, encoding);
        try (BufferedReader read = new BufferedReader(r);){
            String line;
            while ((line = read.readLine()) != null) {
                out.write(line);
                out.write("\n");
            }
        }
    }

    public URLConnection openConnection() throws IOException {
        URLConnection connection = this.source.openConnection();
        connection.setConnectTimeout((int)this.connectTimeout.toMillis());
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (!this.postData.isEmpty()) {
            connection.setDoOutput(true);
            try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                wr.writeBytes(this.postData);
            }
        }
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection lConnection = (HttpURLConnection)connection;
            int status = lConnection.getResponseCode();
            if (status == 302 || status == 301 || status == 303) {
                String newUrl = connection.getHeaderField("location");
                connection = new URLDownload(newUrl).openConnection();
            }
            if (status >= 400 && status < 500) {
                LOGGER.info("HTTP {}, details: {}, {}", new Object[]{status, lConnection.getResponseMessage(), lConnection.getContentLength() > 0 ? lConnection.getContent() : ""});
                throw new IOException(new FetcherClientException("Encountered HTTP %s %s".formatted(status, lConnection.getResponseMessage())));
            }
            if (status >= 500) {
                LOGGER.info("HTTP {}, details: {}, {}", new Object[]{status, lConnection.getResponseMessage(), lConnection.getContentLength() > 0 ? lConnection.getContent() : ""});
                throw new IOException(new FetcherServerException("Encountered HTTP %s %s".formatted(status, lConnection.getResponseMessage())));
            }
        }
        return connection;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        if (connectTimeout != null) {
            this.connectTimeout = connectTimeout;
        }
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }
}

