/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.style;

import java.util.ArrayList;
import java.util.Optional;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.layout.Layout;
import org.jabref.logic.openoffice.style.OOBibStyle;
import org.jabref.logic.openoffice.style.OOPreFormatter;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.openoffice.ootext.OOFormat;
import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.openoffice.style.CitationGroup;
import org.jabref.model.openoffice.style.CitationGroupId;
import org.jabref.model.openoffice.style.CitationGroups;
import org.jabref.model.openoffice.style.CitationPath;
import org.jabref.model.openoffice.style.CitedKey;
import org.jabref.model.openoffice.style.CitedKeys;

public class OOFormatBibliography {
    private static final OOPreFormatter POSTFORMATTER = new OOPreFormatter();
    private static final Field UNIQUEFIER_FIELD = new UnknownField("uniq");

    private OOFormatBibliography() {
    }

    public static OOText formatBibliography(CitationGroups citationGroups, CitedKeys bibliography, OOBibStyle style, boolean alwaysAddCitedOnPages) {
        OOText title = style.getFormattedBibliographyTitle();
        OOText body = OOFormatBibliography.formatBibliographyBody(citationGroups, bibliography, style, alwaysAddCitedOnPages);
        return OOText.fromString(title.toString() + body.toString());
    }

    public static OOText formatBibliographyBody(CitationGroups citationGroups, CitedKeys bibliography, OOBibStyle style, boolean alwaysAddCitedOnPages) {
        StringBuilder stringBuilder = new StringBuilder();
        for (CitedKey citedKey : bibliography.values()) {
            OOText entryText = OOFormatBibliography.formatBibliographyEntry(citationGroups, citedKey, style, alwaysAddCitedOnPages);
            stringBuilder.append(entryText.toString());
        }
        return OOText.fromString(stringBuilder.toString());
    }

    public static OOText formatBibliographyEntry(CitationGroups citationGroups, CitedKey citedKey, OOBibStyle style, boolean alwaysAddCitedOnPages) {
        StringBuilder stringBuilder = new StringBuilder();
        if (style.isNumberEntries()) {
            stringBuilder.append(style.getNumCitationMarkerForBibliography(citedKey).toString());
        }
        stringBuilder.append(OOFormatBibliography.formatBibliographyEntryBody(citedKey, style).toString());
        if (citedKey.getLookupResult().isEmpty() || alwaysAddCitedOnPages) {
            stringBuilder.append(OOFormatBibliography.formatCitedOnPages(citationGroups, citedKey).toString());
        }
        OOText entryText = OOText.fromString(stringBuilder.toString());
        String parStyle = style.getReferenceParagraphFormat();
        return OOFormat.paragraph(entryText, parStyle);
    }

    public static OOText formatBibliographyEntryBody(CitedKey citedKey, OOBibStyle style) {
        if (citedKey.getLookupResult().isEmpty()) {
            return OOText.fromString("Unresolved(%s)".formatted(citedKey.citationKey));
        }
        BibEntry bibentry = citedKey.getLookupResult().get().entry;
        Layout layout = style.getReferenceFormat(bibentry.getType());
        layout.setPostFormatter(POSTFORMATTER);
        return OOFormatBibliography.formatFullReferenceOfBibEntry(layout, bibentry, citedKey.getLookupResult().get().database, citedKey.getUniqueLetter().orElse(null));
    }

    private static OOText formatFullReferenceOfBibEntry(Layout layout, BibEntry entry, BibDatabase database, String uniquefier) {
        Optional<String> oldUniqVal = entry.getField(UNIQUEFIER_FIELD);
        if (uniquefier == null) {
            entry.clearField(UNIQUEFIER_FIELD);
        } else {
            entry.setField(UNIQUEFIER_FIELD, uniquefier);
        }
        OOText formattedText = OOText.fromString(layout.doLayout(entry, database));
        if (oldUniqVal.isPresent()) {
            entry.setField(UNIQUEFIER_FIELD, oldUniqVal.get());
        } else {
            entry.clearField(UNIQUEFIER_FIELD);
        }
        return formattedText;
    }

    private static OOText formatCitedOnPages(CitationGroups citationGroups, CitedKey citedKey) {
        if (!citationGroups.citationGroupsProvideReferenceMarkNameForLinking()) {
            return OOText.fromString("");
        }
        StringBuilder stringBuilder = new StringBuilder();
        String prefix = " (%s: ".formatted(Localization.lang("Cited on pages", new Object[0]));
        String suffix = ")";
        stringBuilder.append(prefix);
        ArrayList<CitationGroup> filteredList = new ArrayList<CitationGroup>();
        for (CitationPath path : citedKey.getCitationPaths()) {
            CitationGroupId groupId = path.group;
            Optional<CitationGroup> group = citationGroups.getCitationGroup(groupId);
            if (group.isEmpty()) {
                throw new IllegalStateException();
            }
            filteredList.add(group.get());
        }
        filteredList.sort((a, b) -> {
            Integer aa = a.getIndexInGlobalOrder().orElseThrow(IllegalStateException::new);
            Integer bb = b.getIndexInGlobalOrder().orElseThrow(IllegalStateException::new);
            return aa.compareTo(bb);
        });
        int index = 0;
        for (CitationGroup group : filteredList) {
            if (index > 0) {
                stringBuilder.append(", ");
            }
            String markName = group.getReferenceMarkNameForLinking().orElseThrow(IllegalStateException::new);
            OOText xref = OOFormat.formatReferenceToPageNumberOfReferenceMark(markName);
            stringBuilder.append(xref.toString());
            ++index;
        }
        stringBuilder.append(")");
        return OOText.fromString(stringBuilder.toString());
    }
}

