/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.style;

import java.util.List;
import java.util.Optional;
import org.jabref.logic.openoffice.style.OOBibStyle;
import org.jabref.logic.openoffice.style.OOProcess;
import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.openoffice.style.CitationGroup;
import org.jabref.model.openoffice.style.CitationGroups;
import org.jabref.model.openoffice.style.CitationMarkerNumericEntry;
import org.jabref.model.openoffice.util.OOListUtil;

class OOProcessNumericMarkers {
    private OOProcessNumericMarkers() {
    }

    static void produceCitationMarkers(CitationGroups citationGroups, OOBibStyle style) {
        assert (style.isNumberEntries());
        if (style.isSortByPosition()) {
            citationGroups.createNumberedBibliographySortedInOrderOfAppearance();
        } else {
            citationGroups.createNumberedBibliographySortedByComparator(OOProcess.AUTHOR_YEAR_TITLE_COMPARATOR);
        }
        for (CitationGroup group : citationGroups.getCitationGroupsInGlobalOrder()) {
            List<CitationMarkerNumericEntry> cits = OOListUtil.map(group.getCitationsInLocalOrder(), e -> e);
            OOText citMarker = style.getNumCitationMarker2(cits);
            group.setCitationMarker(Optional.of(citMarker));
        }
    }
}

