/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.pdf.search;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.jabref.logic.pdf.search.PdfIndexer;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.preferences.FilePreferences;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfIndexerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfIndexerManager.class);
    private static Map<Path, PdfIndexer> indexerMap = new HashMap<Path, PdfIndexer>();
    private static Map<Path, FilePreferences> pathFilePreferencesMap = new HashMap<Path, FilePreferences>();

    public static @NonNull PdfIndexer getIndexer(BibDatabaseContext context, FilePreferences filePreferences) throws IOException {
        Path fulltextIndexPath = context.getFulltextIndexPath();
        PdfIndexer indexer = indexerMap.get(fulltextIndexPath);
        if (indexer != null) {
            FilePreferences storedFilePreferences = pathFilePreferencesMap.get(fulltextIndexPath);
            if (storedFilePreferences.equals(filePreferences)) {
                LOGGER.trace("Found existing indexer for context {}", (Object)context);
                return indexer;
            }
            LOGGER.debug("File preferences have changed, updating indexer");
            indexer.close();
            indexer = PdfIndexer.of(context, filePreferences);
            indexerMap.put(fulltextIndexPath, indexer);
            pathFilePreferencesMap.put(fulltextIndexPath, filePreferences);
            return indexer;
        }
        LOGGER.debug("No indexer found for context {}, creating new one", (Object)context);
        indexer = PdfIndexer.of(context, filePreferences);
        indexerMap.put(fulltextIndexPath, indexer);
        pathFilePreferencesMap.put(fulltextIndexPath, filePreferences);
        return indexer;
    }

    public static void shutdownAllIndexers() {
        indexerMap.values().forEach(indexer -> {
            try {
                indexer.close();
            }
            catch (Exception e) {
                LOGGER.debug("Problem closing PDF indexer", (Throwable)e);
            }
        });
        indexerMap.clear();
        pathFilePreferencesMap.clear();
    }

    public static void shutdownIndexer(BibDatabaseContext context) {
        Path fulltextIndexPath = context.getFulltextIndexPath();
        PdfIndexer indexer = indexerMap.remove(fulltextIndexPath);
        if (indexer != null) {
            try {
                indexer.close();
            }
            catch (IOException e) {
                LOGGER.debug("Could not close indexer", (Throwable)e);
            }
            pathFilePreferencesMap.remove(fulltextIndexPath);
        } else {
            LOGGER.debug("No indexer found for context {}", (Object)context);
        }
    }
}

