/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.pseudonymization;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.jabref.logic.pseudonymization.Pseudonymization;
import org.jooq.lambda.Unchecked;

public class PseudonymizationResultCsvWriter {
    public static void writeValuesMappingAsCsv(Path path, Pseudonymization.Result result) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.UTF_8);
             CSVPrinter csvPrinter = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT);){
            csvPrinter.printRecord(new Object[]{"pseudonymized", "original value"});
            result.valueMapping().entrySet().stream().sorted(Comparator.comparing(entry -> PseudonymizationResultCsvWriter.getKeyPrefix((String)entry.getKey())).thenComparingInt(entry -> PseudonymizationResultCsvWriter.extractNumber((String)entry.getKey()))).forEach(Unchecked.consumer(entry -> csvPrinter.printRecord(new Object[]{entry.getKey(), entry.getValue()})));
        }
    }

    private static String getKeyPrefix(String key) {
        int dashIndex = key.lastIndexOf(45);
        return dashIndex != -1 ? key.substring(0, dashIndex) : key;
    }

    private static int extractNumber(String key) {
        try {
            return Integer.parseInt(key.substring(key.lastIndexOf(45) + 1));
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }
}

