/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.quality.consistency;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.types.EntryType;

public class BibliographyConsistencyCheck {
    public Result check(List<BibEntry> entries) {
        HashMap<EntryType, Set<Field>> entryTypeToFieldsInAnyEntryMap = new HashMap<EntryType, Set<Field>>();
        HashMap<EntryType, Set<Field>> entryTypeToFieldsInAllEntriesMap = new HashMap<EntryType, Set<Field>>();
        HashMap<EntryType, Set<BibEntry>> entryTypeToEntriesMap = new HashMap<EntryType, Set<BibEntry>>();
        BibliographyConsistencyCheck.collectEntriesIntoMaps(entries, entryTypeToFieldsInAnyEntryMap, entryTypeToFieldsInAllEntriesMap, entryTypeToEntriesMap);
        HashMap<EntryType, EntryTypeResult> resultMap = new HashMap<EntryType, EntryTypeResult>();
        entryTypeToFieldsInAnyEntryMap.forEach((entryType, fields) -> {
            Set commonFields = (Set)entryTypeToFieldsInAllEntriesMap.get(entryType);
            assert (commonFields != null);
            HashSet<Field> uniqueFields = new HashSet<Field>((Collection<Field>)fields);
            uniqueFields.removeAll(commonFields);
            if (uniqueFields.isEmpty()) {
                return;
            }
            List<BibEntry> sortedEntries = ((Set)entryTypeToEntriesMap.get(entryType)).stream().filter(entry -> !entry.getFields().equals(commonFields)).sorted(BibliographyConsistencyCheck.getBibEntryComparator()).toList();
            resultMap.put((EntryType)entryType, new EntryTypeResult(uniqueFields, sortedEntries));
        });
        return new Result(resultMap);
    }

    private static Comparator<BibEntry> getBibEntryComparator() {
        return (e1, e2) -> {
            int sizeComparison = e1.getFields().size() - e2.getFields().size();
            if (sizeComparison != 0) {
                return sizeComparison;
            }
            Iterator it1 = e1.getFields().stream().map(Field::getName).sorted().iterator();
            Iterator it2 = e2.getFields().stream().map(Field::getName).sorted().iterator();
            while (it1.hasNext() && it2.hasNext()) {
                int fieldComparison = ((String)it1.next()).compareTo((String)it2.next());
                if (fieldComparison == 0) continue;
                return fieldComparison;
            }
            assert (!it1.hasNext() && !it2.hasNext());
            return 0;
        };
    }

    private static void collectEntriesIntoMaps(List<BibEntry> entries, Map<EntryType, Set<Field>> entryTypeToFieldsInAnyEntryMap, Map<EntryType, Set<Field>> entryTypeToFieldsInAllEntriesMap, Map<EntryType, Set<BibEntry>> entryTypeToEntriesMap) {
        entries.forEach(entry -> {
            EntryType entryType = entry.getType();
            Set fieldsInAnyEntry = entryTypeToFieldsInAnyEntryMap.computeIfAbsent(entryType, k -> new HashSet());
            fieldsInAnyEntry.addAll(entry.getFields());
            Set fieldsInAllEntries = entryTypeToFieldsInAllEntriesMap.computeIfAbsent(entryType, k -> new HashSet<Field>(entry.getFields()));
            fieldsInAllEntries.retainAll(entry.getFields());
            Set entriesOfType = entryTypeToEntriesMap.computeIfAbsent(entryType, k -> new HashSet());
            entriesOfType.add(entry);
        });
    }

    public record Result(Map<EntryType, EntryTypeResult> entryTypeToResultMap) {
    }

    public record EntryTypeResult(Collection<Field> fields, SequencedCollection<BibEntry> sortedEntries) {
    }
}

