/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.quality.consistency;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.quality.consistency.BibliographyConsistencyCheck;
import org.jabref.logic.quality.consistency.BibliographyConsistencyCheckResultWriter;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.Field;

public class BibliographyConsistencyCheckResultTxtWriter
extends BibliographyConsistencyCheckResultWriter {
    private List<Integer> columnWidths;

    public BibliographyConsistencyCheckResultTxtWriter(BibliographyConsistencyCheck.Result result, Writer writer) {
        super(result, writer);
    }

    public BibliographyConsistencyCheckResultTxtWriter(BibliographyConsistencyCheck.Result result, Writer writer, BibEntryTypesManager entryTypesManager, BibDatabaseMode bibDatabaseMode) {
        super(result, writer, entryTypesManager, bibDatabaseMode);
    }

    @Override
    public void writeFindings() throws IOException {
        this.writer.write(Localization.lang("Field Presence Consistency Check Result", new Object[0]));
        this.writer.write("\n\n");
        if (this.result.entryTypeToResultMap().isEmpty()) {
            this.writer.write("No errors found.\n");
            return;
        }
        this.initializeColumnWidths();
        this.outputRow(this.columnNames);
        this.writer.write(this.columnWidths.stream().map(width -> "-".repeat((int)width)).collect(Collectors.joining(" | ", "| ", " |\n")));
        super.writeFindings();
        this.writer.write("\n");
        this.writer.write("%s | %s\n".formatted("x", Localization.lang("required field is present", new Object[0])));
        this.writer.write("%s | %s\n".formatted("o", Localization.lang("optional field is present", new Object[0])));
        this.writer.write("%s | %s\n".formatted("?", Localization.lang("unknown field is present", new Object[0])));
        this.writer.write("%s | %s\n".formatted("-", Localization.lang("field is absent", new Object[0])));
    }

    private void initializeColumnWidths() {
        this.columnWidths = new ArrayList<Integer>(this.columnNames.size());
        Integer max = this.getColumnWidthOfEntryTypes();
        this.columnWidths.add(max);
        max = this.getColumnWidthOfCitationKeys(max);
        this.columnWidths.add(max);
        this.columnWidths.addAll(this.columnNames.stream().skip(2L).map(String::length).toList());
    }

    private Integer getColumnWidthOfEntryTypes() {
        Integer max = this.result.entryTypeToResultMap().keySet().stream().map(entryType -> entryType.getDisplayName().length()).max(Integer::compareTo).get();
        max = Math.max(max, "entry type".length());
        return max;
    }

    private Integer getColumnWidthOfCitationKeys(Integer max) {
        this.result.entryTypeToResultMap().values().stream().flatMap(entryTypeResult -> entryTypeResult.sortedEntries().stream()).map(entry -> entry.getCitationKey().orElse("").length()).max(Integer::compareTo).get();
        return Math.max(max, "citation key".length());
    }

    @Override
    protected void writeBibEntry(BibEntry bibEntry, String entryType, Set<Field> requiredFields, Set<Field> optionalFields) throws IOException {
        List<String> theRecord = this.getFindingsAsList(bibEntry, entryType, requiredFields, optionalFields);
        this.outputRow(theRecord);
    }

    private void outputRow(List<String> theRecord) throws IOException {
        StringJoiner outputJoiner = new StringJoiner(" | ", "| ", " |\n");
        for (int i = 0; i < theRecord.size(); ++i) {
            String fieldValue = theRecord.get(i);
            int columnWidth = this.columnWidths.get(i);
            String formattedField = ("%-" + columnWidth + "s").formatted(fieldValue);
            outputJoiner.add(formattedField);
        }
        this.writer.write(outputJoiner.toString());
    }

    @Override
    public void close() throws IOException {
    }
}

