/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.remote.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import javafx.util.Pair;
import org.jabref.logic.remote.Protocol;
import org.jabref.logic.remote.RemoteMessage;
import org.jabref.logic.remote.RemotePreferences;
import org.jabref.logic.remote.server.RemoteMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteListenerServer
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteListenerServer.class);
    private static final int BACKLOG = 1;
    private static final int TIMEOUT = 1000;
    private final RemoteMessageHandler messageHandler;
    private final ServerSocket serverSocket;

    public RemoteListenerServer(RemoteMessageHandler messageHandler, int port) throws IOException {
        this.serverSocket = new ServerSocket(port, 1, RemotePreferences.getIpAddress());
        this.messageHandler = messageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block18: {
            while (true) {
                if (Thread.interrupted()) break block18;
                try {
                    Socket socket = this.serverSocket.accept();
                    try {
                        socket.setSoTimeout(1000);
                        try (Protocol protocol = new Protocol(socket);){
                            Pair<RemoteMessage, Object> input = protocol.receiveMessage();
                            this.handleMessage(protocol, (RemoteMessage)((Object)input.getKey()), input.getValue());
                        }
                    }
                    finally {
                        if (socket == null) continue;
                        socket.close();
                    }
                }
                catch (SocketException ex) {
                    this.closeServerSocket();
                    return;
                }
                catch (IOException e) {
                    LOGGER.warn("RemoteListenerServer crashed", (Throwable)e);
                }
            }
            finally {
                this.closeServerSocket();
            }
        }
    }

    private void handleMessage(Protocol protocol, RemoteMessage type, Object argument) throws IOException {
        switch (type) {
            case PING: {
                protocol.sendMessage(RemoteMessage.PONG, "jabref");
                break;
            }
            case SEND_COMMAND_LINE_ARGUMENTS: {
                if (argument instanceof String[]) {
                    String[] strings = (String[])argument;
                    this.messageHandler.handleCommandLineArguments(strings);
                    protocol.sendMessage(RemoteMessage.OK);
                    break;
                }
                throw new IOException("Argument for 'SEND_COMMAND_LINE_ARGUMENTS' is not of type String[]. Got " + String.valueOf(argument));
            }
            default: {
                throw new IOException("Unhandled message to server " + String.valueOf((Object)type));
            }
        }
    }

    public void closeServerSocket() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            LOGGER.warn("Unable to close server socket", (Throwable)e);
        }
    }
}

