/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.remote.server;

import java.io.IOException;
import java.net.BindException;
import org.jabref.logic.remote.server.RemoteListenerServerThread;
import org.jabref.logic.remote.server.RemoteMessageHandler;
import org.jabref.logic.util.HeadlessExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteListenerServerManager
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteListenerServerManager.class);
    private RemoteListenerServerThread remoteServerThread;

    public void stop() {
        if (this.isOpen()) {
            this.remoteServerThread.interrupt();
            this.remoteServerThread = null;
            HeadlessExecutorService.INSTANCE.stopRemoteThread();
        }
    }

    public void open(RemoteMessageHandler messageHandler, int port) {
        if (this.isOpen()) {
            return;
        }
        try {
            this.remoteServerThread = new RemoteListenerServerThread(messageHandler, port);
        }
        catch (BindException e) {
            LOGGER.error("There was an error opening the configured network port {}. Please ensure there isn't another application already using that port.", (Object)port);
            this.remoteServerThread = null;
        }
        catch (IOException e) {
            LOGGER.error("Unknown error while opening the network port.", (Throwable)e);
            this.remoteServerThread = null;
        }
    }

    public boolean isOpen() {
        return this.remoteServerThread != null;
    }

    public void start() {
        if (this.isOpen() && this.isNotStartedBefore()) {
            HeadlessExecutorService.INSTANCE.startRemoteThread(this.remoteServerThread);
        }
    }

    public boolean isNotStartedBefore() {
        return this.remoteServerThread == null || this.remoteServerThread.getState() == Thread.State.NEW;
    }

    public void openAndStart(RemoteMessageHandler messageHandler, int port) {
        this.open(messageHandler, port);
        this.start();
    }

    @Override
    public void close() {
        this.stop();
    }
}

