/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.shared;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.jabref.logic.shared.DBMSType;
import org.jabref.logic.shared.DatabaseConnectionProperties;
import org.jabref.logic.shared.prefs.SharedDatabasePreferences;
import org.jabref.logic.shared.security.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBMSConnectionProperties
implements DatabaseConnectionProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBMSConnectionProperties.class);
    private DBMSType type;
    private String host;
    private int port;
    private String database;
    private String user;
    private String password;
    private boolean allowPublicKeyRetrieval;
    private final boolean useSSL;
    private String serverTimezone = "";
    private String jdbcUrl = "";
    private final boolean expertMode;
    private String keyStore;

    public DBMSConnectionProperties(SharedDatabasePreferences prefs) {
        if (prefs.getType().isPresent()) {
            Optional<DBMSType> dbmsType = DBMSType.fromString(prefs.getType().get());
            dbmsType.ifPresent(value -> {
                this.type = value;
            });
        }
        prefs.getHost().ifPresent(theHost -> {
            this.host = theHost;
        });
        prefs.getPort().ifPresent(thePort -> {
            this.port = Integer.parseInt(thePort);
        });
        prefs.getName().ifPresent(theDatabase -> {
            this.database = theDatabase;
        });
        prefs.getKeyStoreFile().ifPresent(theKeystore -> {
            this.keyStore = theKeystore;
        });
        prefs.getServerTimezone().ifPresent(theServerTimezone -> {
            this.serverTimezone = theServerTimezone;
        });
        prefs.getJdbcUrl().ifPresent(theJdbcUrl -> {
            this.jdbcUrl = theJdbcUrl;
        });
        this.expertMode = prefs.isUseExpertMode();
        this.useSSL = prefs.isUseSSL();
        if (prefs.getUser().isPresent()) {
            this.user = prefs.getUser().get();
            if (prefs.getPassword().isPresent()) {
                try {
                    this.password = new Password(prefs.getPassword().get().toCharArray(), prefs.getUser().get()).decrypt();
                }
                catch (UnsupportedEncodingException | GeneralSecurityException e) {
                    LOGGER.error("Could not decrypt password", (Throwable)e);
                }
            }
        }
        if (prefs.getPassword().isEmpty()) {
            this.password = "";
        }
    }

    DBMSConnectionProperties(DBMSType type, String host, int port, String database, String user, String password, boolean useSSL, boolean allowPublicKeyRetrieval, String serverTimezone, String keyStore, String jdbcUrl, boolean expertMode) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.database = database;
        this.user = user;
        this.password = password;
        this.useSSL = useSSL;
        this.allowPublicKeyRetrieval = allowPublicKeyRetrieval;
        this.serverTimezone = serverTimezone;
        this.keyStore = keyStore;
        this.jdbcUrl = jdbcUrl;
        this.expertMode = expertMode;
    }

    @Override
    public DBMSType getType() {
        return this.type;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean isUseSSL() {
        return this.useSSL;
    }

    @Override
    public boolean isAllowPublicKeyRetrieval() {
        return this.allowPublicKeyRetrieval;
    }

    @Override
    public String getServerTimezone() {
        return this.serverTimezone;
    }

    @Override
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @Override
    public boolean isUseExpertMode() {
        return this.expertMode;
    }

    public String getUrl() {
        return this.type.getUrl(this.host, this.port, this.database);
    }

    public Properties asProperties() {
        Properties props = new Properties();
        props.setProperty("user", this.user);
        props.setProperty("password", this.password);
        props.setProperty("serverTimezone", this.serverTimezone);
        if (this.useSSL) {
            props.setProperty("ssl", Boolean.toString(true));
            props.setProperty("useSSL", Boolean.toString(true));
        }
        if (this.allowPublicKeyRetrieval) {
            props.setProperty("allowPublicKeyRetrieval", Boolean.toString(true));
        }
        return props;
    }

    @Override
    public String getKeyStore() {
        return this.keyStore;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DBMSConnectionProperties)) {
            return false;
        }
        DBMSConnectionProperties properties = (DBMSConnectionProperties)obj;
        return Objects.equals((Object)this.type, (Object)properties.getType()) && this.host.equalsIgnoreCase(properties.getHost()) && Objects.equals(this.port, properties.getPort()) && Objects.equals(this.database, properties.getDatabase()) && Objects.equals(this.user, properties.getUser()) && Objects.equals(this.useSSL, properties.isUseSSL()) && Objects.equals(this.allowPublicKeyRetrieval, properties.isAllowPublicKeyRetrieval()) && Objects.equals(this.serverTimezone, properties.getServerTimezone()) && Objects.equals(this.keyStore, properties.getKeyStore()) && Objects.equals(this.jdbcUrl, properties.getJdbcUrl()) && Objects.equals(this.expertMode, properties.isUseExpertMode());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.host, this.port, this.database, this.user, this.useSSL, this.allowPublicKeyRetrieval, this.serverTimezone, this.keyStore, this.jdbcUrl, this.expertMode});
    }

    @Override
    public boolean isValid() {
        return this.type != null && this.host != null && this.port > 0 && this.database != null && this.user != null && this.password != null;
    }
}

