/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.shared.prefs;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Optional;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jabref.logic.shared.DatabaseConnectionProperties;
import org.jabref.logic.shared.security.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedDatabasePreferences {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedDatabasePreferences.class);
    private static final String DEFAULT_NODE = "default";
    private static final String PREFERENCES_PATH_NAME = "/org/jabref-shared";
    private static final String SHARED_DATABASE_TYPE = "sharedDatabaseType";
    private static final String SHARED_DATABASE_HOST = "sharedDatabaseHost";
    private static final String SHARED_DATABASE_PORT = "sharedDatabasePort";
    private static final String SHARED_DATABASE_NAME = "sharedDatabaseName";
    private static final String SHARED_DATABASE_USER = "sharedDatabaseUser";
    private static final String SHARED_DATABASE_PASSWORD = "sharedDatabasePassword";
    private static final String SHARED_DATABASE_FOLDER = "sharedDatabaseFolder";
    private static final String SHARED_DATABASE_AUTOSAVE = "sharedDatabaseAutosave";
    private static final String SHARED_DATABASE_REMEMBER_PASSWORD = "sharedDatabaseRememberPassword";
    private static final String SHARED_DATABASE_USE_SSL = "sharedDatabaseUseSSL";
    private static final String SHARED_DATABASE_KEYSTORE_FILE = "sharedDatabaseKeyStoreFile";
    private static final String SHARED_DATABASE_SERVER_TIMEZONE = "sharedDatabaseServerTimezone";
    private static final String SHARED_DATABASE_EXPERT_MODE = "sharedDatabaseExpertMode";
    private static final String SHARED_DATABASE_JDBC_URL = "sharedDatabaseJdbcUrl";
    private final Preferences internalPrefs;

    public SharedDatabasePreferences() {
        this(DEFAULT_NODE);
    }

    public SharedDatabasePreferences(String sharedDatabaseID) {
        this.internalPrefs = Preferences.userRoot().node(PREFERENCES_PATH_NAME).node(sharedDatabaseID);
    }

    public Optional<String> getType() {
        return this.getOptionalValue(SHARED_DATABASE_TYPE);
    }

    public Optional<String> getHost() {
        return this.getOptionalValue(SHARED_DATABASE_HOST);
    }

    public Optional<String> getPort() {
        return this.getOptionalValue(SHARED_DATABASE_PORT);
    }

    public Optional<String> getName() {
        return this.getOptionalValue(SHARED_DATABASE_NAME);
    }

    public Optional<String> getUser() {
        return this.getOptionalValue(SHARED_DATABASE_USER);
    }

    public Optional<String> getPassword() {
        return this.getOptionalValue(SHARED_DATABASE_PASSWORD);
    }

    public Optional<String> getKeyStoreFile() {
        return this.getOptionalValue(SHARED_DATABASE_KEYSTORE_FILE);
    }

    public Optional<String> getServerTimezone() {
        return this.getOptionalValue(SHARED_DATABASE_SERVER_TIMEZONE);
    }

    public boolean getRememberPassword() {
        return this.internalPrefs.getBoolean(SHARED_DATABASE_REMEMBER_PASSWORD, false);
    }

    public Optional<String> getFolder() {
        return this.getOptionalValue(SHARED_DATABASE_FOLDER);
    }

    public boolean getAutosave() {
        return this.internalPrefs.getBoolean(SHARED_DATABASE_AUTOSAVE, false);
    }

    public boolean isUseSSL() {
        return this.internalPrefs.getBoolean(SHARED_DATABASE_USE_SSL, false);
    }

    public void setType(String type) {
        this.internalPrefs.put(SHARED_DATABASE_TYPE, type);
    }

    public void setHost(String host) {
        this.internalPrefs.put(SHARED_DATABASE_HOST, host);
    }

    public void setPort(String port) {
        this.internalPrefs.put(SHARED_DATABASE_PORT, port);
    }

    public void setName(String name) {
        this.internalPrefs.put(SHARED_DATABASE_NAME, name);
    }

    public void setUser(String user) {
        this.internalPrefs.put(SHARED_DATABASE_USER, user);
    }

    public void setPassword(String password) {
        this.internalPrefs.put(SHARED_DATABASE_PASSWORD, password);
    }

    public void setRememberPassword(boolean rememberPassword) {
        this.internalPrefs.putBoolean(SHARED_DATABASE_REMEMBER_PASSWORD, rememberPassword);
    }

    public void setFolder(String folder) {
        this.internalPrefs.put(SHARED_DATABASE_FOLDER, folder);
    }

    public void setAutosave(boolean autosave) {
        this.internalPrefs.putBoolean(SHARED_DATABASE_AUTOSAVE, autosave);
    }

    public void setUseSSL(boolean useSSL) {
        this.internalPrefs.putBoolean(SHARED_DATABASE_USE_SSL, useSSL);
    }

    public void setKeystoreFile(String keystoreFile) {
        this.internalPrefs.put(SHARED_DATABASE_KEYSTORE_FILE, keystoreFile);
    }

    public void setServerTimezone(String serverTimezone) {
        this.internalPrefs.put(SHARED_DATABASE_SERVER_TIMEZONE, serverTimezone);
    }

    public void clearPassword() {
        this.internalPrefs.remove(SHARED_DATABASE_PASSWORD);
    }

    public void setExpertMode(boolean expertMode) {
        this.internalPrefs.putBoolean(SHARED_DATABASE_EXPERT_MODE, expertMode);
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.internalPrefs.put(SHARED_DATABASE_JDBC_URL, jdbcUrl);
    }

    public boolean isUseExpertMode() {
        return this.internalPrefs.getBoolean(SHARED_DATABASE_EXPERT_MODE, false);
    }

    public Optional<String> getJdbcUrl() {
        return this.getOptionalValue(SHARED_DATABASE_JDBC_URL);
    }

    public void clear() throws BackingStoreException {
        this.internalPrefs.clear();
    }

    private Optional<String> getOptionalValue(String key) {
        return Optional.ofNullable(this.internalPrefs.get(key, null));
    }

    public static void clearAll() throws BackingStoreException {
        Preferences.userRoot().node(PREFERENCES_PATH_NAME).clear();
    }

    public void putAllDBMSConnectionProperties(DatabaseConnectionProperties properties) {
        assert (properties.isValid());
        this.setType(properties.getType().toString());
        this.setHost(properties.getHost());
        this.setPort(String.valueOf(properties.getPort()));
        this.setName(properties.getDatabase());
        this.setUser(properties.getUser());
        this.setUseSSL(properties.isUseSSL());
        this.setKeystoreFile(properties.getKeyStore());
        this.setServerTimezone(properties.getServerTimezone());
        this.setExpertMode(properties.isUseExpertMode());
        this.setJdbcUrl(properties.getJdbcUrl());
        try {
            this.setPassword(new Password(properties.getPassword().toCharArray(), properties.getUser()).encrypt());
        }
        catch (UnsupportedEncodingException | GeneralSecurityException e) {
            LOGGER.error("Could not store the password due to encryption problems.", (Throwable)e);
        }
    }
}

