/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.shared.security;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Password {
    private final byte[] phrase;
    private final Cipher cipher;
    private final SecretKeySpec secretKey;
    private final IvParameterSpec ivSpec;

    public Password(char[] phrase, String key) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this(new String(phrase), key);
    }

    public Password(String phrase, String key) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.phrase = phrase.getBytes();
        this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        this.secretKey = new SecretKeySpec(this.get128BitHash(key.getBytes()), "AES");
        this.ivSpec = new IvParameterSpec("ThisIsA128BitKey".getBytes());
    }

    public String encrypt() throws GeneralSecurityException, UnsupportedEncodingException {
        this.cipher.init(1, (Key)this.secretKey, this.ivSpec);
        return new String(Base64.getEncoder().encode(this.cipher.doFinal(this.phrase)), StandardCharsets.UTF_8);
    }

    public String decrypt() throws GeneralSecurityException, UnsupportedEncodingException {
        this.cipher.init(2, (Key)this.secretKey, this.ivSpec);
        return new String(this.cipher.doFinal(Base64.getDecoder().decode(this.phrase)), StandardCharsets.UTF_8);
    }

    private byte[] get128BitHash(byte[] byteArrayToHash) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(byteArrayToHash);
        return Arrays.copyOf(messageDigest.digest(), 16);
    }
}

