/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util;

import java.net.URISyntaxException;
import java.util.Optional;
import org.apache.hc.core5.net.URIBuilder;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;

public class ExternalLinkCreator {
    private static final String SHORTSCIENCE_SEARCH_URL = "https://www.shortscience.org/internalsearch";

    public static Optional<String> getShortScienceSearchURL(BibEntry entry) {
        return entry.getField(StandardField.TITLE).map(title -> {
            URIBuilder uriBuilder;
            try {
                uriBuilder = new URIBuilder(SHORTSCIENCE_SEARCH_URL);
            }
            catch (URISyntaxException e) {
                throw new AssertionError("ShortScience URL is invalid.", e);
            }
            uriBuilder.addParameter("q", title);
            return uriBuilder.toString();
        });
    }
}

