/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jabref.logic.util.io.FileFinder;
import org.jabref.logic.util.io.FileNameCleaner;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;

class CitationKeyBasedFileFinder
implements FileFinder {
    private final boolean exactKeyOnly;

    CitationKeyBasedFileFinder(boolean exactKeyOnly) {
        this.exactKeyOnly = exactKeyOnly;
    }

    @Override
    public List<Path> findAssociatedFiles(BibEntry entry, List<Path> directories, List<String> extensions) throws IOException {
        Objects.requireNonNull(directories);
        Objects.requireNonNull(entry);
        Optional<String> citeKeyOptional = entry.getCitationKey();
        if (StringUtil.isBlank(citeKeyOptional)) {
            return Collections.emptyList();
        }
        String citeKey = citeKeyOptional.get();
        ArrayList<Path> result = new ArrayList<Path>();
        Set<Path> filesWithExtension = this.findFilesByExtension(directories, extensions);
        for (Path file : filesWithExtension) {
            String name = file.getFileName().toString();
            String nameWithoutExtension = FileUtil.getBaseName(name);
            if (nameWithoutExtension.equals(citeKey)) {
                result.add(file);
                continue;
            }
            if (this.exactKeyOnly || !this.matches(name, citeKey)) continue;
            result.add(file);
        }
        return result.stream().sorted().collect(Collectors.toList());
    }

    private boolean matches(String filename, String citeKey) {
        boolean startsWithKey = filename.startsWith(FileNameCleaner.cleanFileName(citeKey));
        if (startsWithKey) {
            char charAfterKey = filename.charAt(citeKey.length());
            return !"abcdefghijklmnopqrstuvwxyz".contains(Character.toString(charAfterKey));
        }
        return false;
    }

    private Set<Path> findFilesByExtension(List<Path> directories, List<String> extensions) throws IOException {
        Objects.requireNonNull(extensions, "Extensions must not be null!");
        BiPredicate<Path, BasicFileAttributes> isFileWithCorrectExtension = (path, attributes) -> !Files.isDirectory(path, new LinkOption[0]) && extensions.contains(FileUtil.getFileExtension(path).orElse(""));
        HashSet<Path> result = new HashSet<Path>();
        for (Path directory : directories) {
            if (!Files.exists(directory, new LinkOption[0])) continue;
            try {
                Stream<Path> pathStream = Files.find(directory, Integer.MAX_VALUE, isFileWithCorrectExtension, FileVisitOption.FOLLOW_LINKS);
                try {
                    result.addAll(pathStream.collect(Collectors.toSet()));
                }
                finally {
                    if (pathStream == null) continue;
                    pathStream.close();
                }
            }
            catch (UncheckedIOException e) {
                throw new IOException("Problem in finding files", e);
            }
        }
        return result;
    }
}

