/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.strings;

import org.jabref.logic.formatter.casechanger.CapitalizeFormatter;
import org.jabref.logic.formatter.casechanger.LowerCaseFormatter;
import org.jabref.logic.formatter.casechanger.UpperCaseFormatter;
import org.jabref.model.util.ResultingStringState;

public class StringManipulator {
    private static ResultingStringState setWordCase(String text, int caretPosition, LetterCase targetCase) {
        int wordStartPosition;
        int nextWordBoundary = StringManipulator.getNextWordBoundary(caretPosition, text, Direction.NEXT);
        for (wordStartPosition = caretPosition; wordStartPosition < nextWordBoundary && Character.isWhitespace(text.charAt(wordStartPosition)); ++wordStartPosition) {
        }
        String result = switch (targetCase.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new UpperCaseFormatter().format(text.substring(wordStartPosition, nextWordBoundary));
            case 1 -> new LowerCaseFormatter().format(text.substring(wordStartPosition, nextWordBoundary));
            case 2 -> new CapitalizeFormatter().format(text.substring(wordStartPosition, nextWordBoundary));
        };
        return new ResultingStringState(nextWordBoundary, text.substring(0, wordStartPosition) + result + text.substring(nextWordBoundary));
    }

    static ResultingStringState deleteUntilWordBoundary(int caretPosition, String text, Direction direction) {
        int nextWordBoundary = StringManipulator.getNextWordBoundary(caretPosition, text, direction);
        return switch (direction.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new ResultingStringState(caretPosition, text.substring(0, caretPosition) + text.substring(nextWordBoundary));
            case 1 -> new ResultingStringState(nextWordBoundary, text.substring(0, nextWordBoundary) + text.substring(caretPosition));
        };
    }

    static int getNextWordBoundary(int caretPosition, String text, Direction direction) {
        int i;
        block5: {
            block4: {
                if (direction != Direction.PREVIOUS) break block4;
                for (i = caretPosition; i > 0 && Character.isWhitespace(text.charAt(i + direction.OFFSET)); i += direction.OFFSET) {
                }
                while (i > 0 && !Character.isWhitespace(text.charAt(i + direction.OFFSET))) {
                    i += direction.OFFSET;
                }
                break block5;
            }
            if (direction != Direction.NEXT) break block5;
            while (i < text.length() && Character.isWhitespace(text.charAt(i))) {
                i += direction.OFFSET;
            }
            while (i < text.length() && !Character.isWhitespace(text.charAt(i))) {
                i += direction.OFFSET;
            }
        }
        return i;
    }

    public static ResultingStringState capitalize(int caretPosition, String text) {
        return StringManipulator.setWordCase(text, caretPosition, LetterCase.CAPITALIZED);
    }

    public static ResultingStringState uppercase(int caretPosition, String text) {
        return StringManipulator.setWordCase(text, caretPosition, LetterCase.UPPER);
    }

    public static ResultingStringState lowercase(int caretPosition, String text) {
        return StringManipulator.setWordCase(text, caretPosition, LetterCase.LOWER);
    }

    public static ResultingStringState killWord(int caretPosition, String text) {
        return StringManipulator.deleteUntilWordBoundary(caretPosition, text, Direction.NEXT);
    }

    public static ResultingStringState backwardKillWord(int caretPosition, String text) {
        return StringManipulator.deleteUntilWordBoundary(caretPosition, text, Direction.PREVIOUS);
    }

    static enum Direction {
        NEXT(1),
        PREVIOUS(-1);

        public final int OFFSET;

        private Direction(int offset) {
            this.OFFSET = offset;
        }
    }

    private static enum LetterCase {
        UPPER,
        LOWER,
        CAPITALIZED;

    }
}

