/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.xmp;

import java.util.Map;
import java.util.Optional;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.EntryTypeFactory;

public class DocumentInformationExtractor {
    private final PDDocumentInformation documentInformation;
    private final BibEntry bibEntry;

    public DocumentInformationExtractor(PDDocumentInformation documentInformation) {
        this.documentInformation = documentInformation;
        this.bibEntry = new BibEntry();
    }

    private void extractAuthor() {
        String s = this.documentInformation.getAuthor();
        if (s != null) {
            this.bibEntry.setField(StandardField.AUTHOR, s);
        }
    }

    private void extractTitle() {
        String s = this.documentInformation.getTitle();
        if (s != null) {
            this.bibEntry.setField(StandardField.TITLE, s);
        }
    }

    private void extractKeywords() {
        String s = this.documentInformation.getKeywords();
        if (s != null) {
            this.bibEntry.setField(StandardField.KEYWORDS, s);
        }
    }

    private void extractSubject() {
        String s = this.documentInformation.getSubject();
        if (s != null) {
            this.bibEntry.setField(StandardField.ABSTRACT, s);
        }
    }

    private void extractOtherFields() {
        COSDictionary dict = this.documentInformation.getCOSObject();
        for (Map.Entry o : dict.entrySet()) {
            String key = ((COSName)o.getKey()).getName();
            if (!key.startsWith("bibtex/")) continue;
            String value = dict.getString(key);
            Field field = FieldFactory.parseField(key = key.substring("bibtex/".length()));
            if (InternalField.TYPE_HEADER == field) {
                this.bibEntry.setType(EntryTypeFactory.parse(value));
                continue;
            }
            this.bibEntry.setField(field, value);
        }
    }

    public Optional<BibEntry> extractBibtexEntry() {
        this.bibEntry.setType(BibEntry.DEFAULT_TYPE);
        this.extractAuthor();
        this.extractTitle();
        this.extractKeywords();
        this.extractSubject();
        this.extractOtherFields();
        if (this.bibEntry.getFields().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.bibEntry);
    }
}

