/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.xmp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.jabref.logic.xmp.DocumentInformationExtractor;
import org.jabref.logic.xmp.DublinCoreExtractor;
import org.jabref.logic.xmp.XmpPreferences;
import org.jabref.logic.xmp.XmpUtilShared;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.schema.DublinCoreSchemaCustom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmpUtilReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmpUtilReader.class);
    private static final String START_TAG = "<rdf:Description";
    private static final String END_TAG = "</rdf:Description>";

    public XmpUtilReader() {
        System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
    }

    public List<XMPMetadata> readRawXmp(Path path) throws IOException {
        try (PDDocument document = this.loadWithAutomaticDecryption(path);){
            List<XMPMetadata> list = this.getXmpMetadata(document);
            return list;
        }
    }

    public List<BibEntry> readXmp(Path path, XmpPreferences xmpPreferences) throws IOException {
        LinkedList<BibEntry> result = new LinkedList<BibEntry>();
        try (PDDocument document = this.loadWithAutomaticDecryption(path);){
            List<XMPMetadata> xmpMetaList = this.getXmpMetadata(document);
            if (!xmpMetaList.isEmpty()) {
                for (XMPMetadata xmpMeta : xmpMetaList) {
                    DublinCoreSchema dcSchema = DublinCoreSchemaCustom.copyDublinCoreSchema(xmpMeta.getDublinCoreSchema());
                    if (dcSchema == null) continue;
                    DublinCoreExtractor dcExtractor = new DublinCoreExtractor(dcSchema, xmpPreferences, new BibEntry());
                    Optional<BibEntry> entry2 = dcExtractor.extractBibtexEntry();
                    entry2.ifPresent(result::add);
                }
            }
            if (result.isEmpty()) {
                PDDocumentInformation documentInformation = document.getDocumentInformation();
                DocumentInformationExtractor diExtractor = new DocumentInformationExtractor(documentInformation);
                Optional<BibEntry> entry3 = diExtractor.extractBibtexEntry();
                entry3.ifPresent(result::add);
            }
        }
        result.forEach(entry -> entry.addFile(new LinkedFile("", path.toAbsolutePath(), "PDF")));
        return result;
    }

    private List<XMPMetadata> getXmpMetadata(PDDocument document) {
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        PDMetadata metaRaw = catalog.getMetadata();
        ArrayList<XMPMetadata> metaList = new ArrayList<XMPMetadata>();
        if (metaRaw == null) {
            return metaList;
        }
        String xmp = metaRaw.getCOSObject().toTextString();
        int startDescriptionSection = xmp.indexOf(START_TAG);
        int endDescriptionSection = xmp.lastIndexOf(END_TAG) + END_TAG.length();
        if (startDescriptionSection < 0 || startDescriptionSection > endDescriptionSection || endDescriptionSection == END_TAG.length() - 1) {
            return metaList;
        }
        String start = xmp.substring(0, startDescriptionSection);
        String[] descriptionsArray = xmp.substring(startDescriptionSection, endDescriptionSection).split(END_TAG);
        String end = xmp.substring(endDescriptionSection);
        for (String s : descriptionsArray) {
            String xmpMetaString = start + s + END_TAG + end;
            try {
                metaList.add(XmpUtilShared.parseXmpMetadata(new ByteArrayInputStream(xmpMetaString.getBytes())));
            }
            catch (IOException ex) {
                LOGGER.warn("Problem parsing XMP schema. Continuing with other schemas.", (Throwable)ex);
            }
        }
        return metaList;
    }

    public PDDocument loadWithAutomaticDecryption(Path path) throws IOException {
        return Loader.loadPDF((File)path.toFile());
    }
}

