/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.migrations;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.collections.ObservableList;
import org.jabref.logic.groups.DefaultGroupsFactory;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.migrations.PostOpenMigration;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.groups.ExplicitGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.groups.GroupTreeNode;

public class ConvertMarkingToGroups
implements PostOpenMigration {
    private static final Pattern MARKING_PATTERN = Pattern.compile("\\[(.*):(\\d+)\\]");

    @Override
    public void performMigration(ParserResult parserResult) {
        Objects.requireNonNull(parserResult);
        ObservableList<BibEntry> entries = parserResult.getDatabase().getEntries();
        Multimap<String, BibEntry> markings = this.getMarkingWithEntries((List<BibEntry>)entries);
        if (!markings.isEmpty()) {
            GroupTreeNode markingRoot = GroupTreeNode.fromGroup(new ExplicitGroup(Localization.lang("Markings", new Object[0]), GroupHierarchyType.INCLUDING, Character.valueOf(',')));
            for (Map.Entry marking : markings.asMap().entrySet()) {
                String markingName = (String)marking.getKey();
                Collection markingMatchedEntries = (Collection)marking.getValue();
                GroupTreeNode markingGroup = markingRoot.addSubgroup(new ExplicitGroup(markingName, GroupHierarchyType.INCLUDING, Character.valueOf(',')));
                markingGroup.addEntriesToGroup(markingMatchedEntries);
            }
            if (!parserResult.getMetaData().getGroups().isPresent()) {
                parserResult.getMetaData().setGroups(GroupTreeNode.fromGroup(DefaultGroupsFactory.getAllEntriesGroup()));
            }
            GroupTreeNode root = parserResult.getMetaData().getGroups().get();
            root.addChild(markingRoot, 0);
            parserResult.getMetaData().setGroups(root);
            this.clearMarkings((List<BibEntry>)entries);
        }
    }

    private Multimap<String, BibEntry> getMarkingWithEntries(List<BibEntry> entries) {
        ListMultimap markings = MultimapBuilder.treeKeys().linkedListValues().build();
        for (BibEntry entry : entries) {
            Optional<String> marking = entry.getField(InternalField.MARKED_INTERNAL);
            if (!marking.isPresent()) continue;
            Matcher matcher = MARKING_PATTERN.matcher(marking.get());
            if (matcher.find()) {
                String owner = matcher.group(1);
                String number = matcher.group(2);
                markings.put((Object)(owner + ":" + number), (Object)entry);
                continue;
            }
            markings.put((Object)marking.get(), (Object)entry);
        }
        return markings;
    }

    private void clearMarkings(List<BibEntry> entries) {
        entries.forEach(entry -> entry.clearField(InternalField.MARKED_INTERNAL));
    }
}

