/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.database;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.event.EntriesRemovedEvent;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.event.FieldChangedEvent;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldProperty;
import org.jabref.model.entry.field.InternalField;

public class KeyChangeListener {
    private final BibDatabase database;

    public KeyChangeListener(BibDatabase database) {
        this.database = database;
    }

    @Subscribe
    public void listen(FieldChangedEvent event) {
        if (event.getField().equals(InternalField.KEY_FIELD)) {
            String newKey = event.getNewValue();
            String oldKey = event.getOldValue();
            this.updateEntryLinks(newKey, oldKey);
        }
    }

    @Subscribe
    public void listen(EntriesRemovedEvent event) {
        List<BibEntry> entries = event.getBibEntries();
        for (BibEntry entry : entries) {
            Optional<String> citeKey = entry.getCitationKey();
            citeKey.ifPresent(oldkey -> this.updateEntryLinks(null, (String)oldkey));
        }
    }

    private void updateEntryLinks(String newKey, String oldKey) {
        for (BibEntry entry : this.database.getEntries()) {
            entry.getFields(field -> field.getProperties().contains((Object)FieldProperty.SINGLE_ENTRY_LINK)).forEach(field -> {
                String fieldContent = entry.getField((Field)field).orElseThrow();
                this.replaceSingleKeyInField(newKey, oldKey, entry, (Field)field, fieldContent);
            });
            entry.getFields(field -> field.getProperties().contains((Object)FieldProperty.MULTIPLE_ENTRY_LINK)).forEach(field -> {
                String fieldContent = entry.getField((Field)field).orElseThrow();
                this.replaceKeyInMultiplesKeyField(newKey, oldKey, entry, (Field)field, fieldContent);
            });
        }
    }

    private void replaceKeyInMultiplesKeyField(String newKey, String oldKey, BibEntry entry, Field field, String fieldContent) {
        ArrayList<String> keys = new ArrayList<String>(Arrays.asList(fieldContent.split(",")));
        int index = keys.indexOf(oldKey);
        if (index != -1) {
            if (newKey == null) {
                keys.remove(index);
            } else {
                keys.set(index, newKey);
            }
            entry.setField(field, String.join((CharSequence)",", keys));
        }
    }

    private void replaceSingleKeyInField(String newKey, String oldKey, BibEntry entry, Field field, String fieldContent) {
        if (fieldContent.equals(oldKey)) {
            if (newKey == null) {
                entry.clearField(field);
            } else {
                entry.setField(field, newKey);
            }
        }
    }
}

