/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jabref.architecture.AllowedToUseLogic;
import org.jabref.logic.importer.AuthorListParser;
import org.jabref.model.entry.Author;
import org.jspecify.annotations.NonNull;

@AllowedToUseLogic(value="because it needs access to AuthorList parser")
public class AuthorList
implements Iterable<Author> {
    private static final Map<String, AuthorList> AUTHOR_CACHE = Collections.synchronizedMap(new WeakHashMap());
    private final List<Author> authors;
    private AuthorList latexFreeAuthors;

    private AuthorList(List<Author> authors) {
        this.authors = Objects.requireNonNull(authors);
    }

    public static AuthorList of(List<Author> authors) {
        return new AuthorList(List.copyOf(authors));
    }

    public static AuthorList of(Author ... authors) {
        return new AuthorList(List.of(authors));
    }

    public static Collector<Author, ?, AuthorList> collect() {
        return Collectors.collectingAndThen(Collectors.toUnmodifiableList(), AuthorList::new);
    }

    private static String andCoordinatedConjunction(List<Author> authors, Function<Author, String> style, boolean oxfordComma) {
        List<String> formattedAuthors = authors.stream().map(style).collect(Collectors.toUnmodifiableList());
        return AuthorList.andCoordinatedConjunction(formattedAuthors, oxfordComma);
    }

    private static String andCoordinatedConjunction(List<String> authors, boolean oxfordComma) {
        String lastDelimiter = oxfordComma ? ", and " : " and ";
        int lastIndex = authors.size() - 1;
        return switch (authors.size()) {
            case 0 -> "";
            case 1 -> authors.getFirst();
            case 2 -> authors.getFirst() + " and " + authors.get(1);
            default -> String.join((CharSequence)", ", authors.subList(0, lastIndex)) + lastDelimiter + authors.get(lastIndex);
        };
    }

    public static AuthorList parse(@NonNull String authors) {
        return AUTHOR_CACHE.computeIfAbsent(authors, string -> {
            AuthorListParser parser = new AuthorListParser();
            return parser.parse((String)string);
        });
    }

    public static String fixAuthorFirstNameFirstCommas(String authors, boolean abbreviate, boolean oxfordComma) {
        return AuthorList.parse(authors).getAsFirstLastNames(abbreviate, oxfordComma);
    }

    public static String fixAuthorFirstNameFirst(String authors) {
        return AuthorList.parse(authors).getAsFirstLastNamesWithAnd();
    }

    public static String fixAuthorLastNameFirstCommas(String authors, boolean abbreviate, boolean oxfordComma) {
        return AuthorList.parse(authors).getAsLastFirstNames(abbreviate, oxfordComma);
    }

    public static String fixAuthorLastNameFirst(String authors) {
        return AuthorList.parse(authors).getAsLastFirstNamesWithAnd(false);
    }

    public static String fixAuthorLastNameFirst(String authors, boolean abbreviate) {
        return AuthorList.parse(authors).getAsLastFirstNamesWithAnd(abbreviate);
    }

    public static String fixAuthorLastNameOnlyCommas(String authors, boolean oxfordComma) {
        return AuthorList.parse(authors).getAsLastNames(oxfordComma);
    }

    public static String fixAuthorForAlphabetization(String authors) {
        return AuthorList.parse(authors).getForAlphabetization();
    }

    public static String fixAuthorNatbib(String authors) {
        return AuthorList.parse(authors).getAsNatbib();
    }

    public int getNumberOfAuthors() {
        return this.authors.size();
    }

    public boolean isEmpty() {
        return this.authors.isEmpty();
    }

    public Author getAuthor(int i) {
        return this.authors.get(i);
    }

    public List<Author> getAuthors() {
        return this.authors;
    }

    public AuthorList latexFree() {
        if (this.latexFreeAuthors == null) {
            this.latexFreeAuthors.latexFreeAuthors = this.latexFreeAuthors = new AuthorList(this.authors.stream().map(Author::latexFree).collect(Collectors.toUnmodifiableList()));
        }
        return this.latexFreeAuthors;
    }

    public String getAsNatbib() {
        List<Author> authors = this.getAuthors();
        return switch (authors.size()) {
            case 0 -> "";
            case 1 -> authors.getFirst().getNamePrefixAndFamilyName();
            case 2 -> authors.getFirst().getNamePrefixAndFamilyName() + " and " + authors.get(1).getNamePrefixAndFamilyName();
            default -> authors.getFirst().getNamePrefixAndFamilyName() + " et al.";
        };
    }

    public String getAsLastNames(boolean oxfordComma) {
        return AuthorList.andCoordinatedConjunction(this.getAuthors(), Author::getNamePrefixAndFamilyName, oxfordComma);
    }

    public String getAsLastFirstNames(boolean abbreviate, boolean oxfordComma) {
        return AuthorList.andCoordinatedConjunction(this.getAuthors(), auth -> auth.getFamilyGiven(abbreviate), oxfordComma);
    }

    public String toString() {
        return this.authors.toString();
    }

    public String getAsLastFirstNamesWithAnd(boolean abbreviate) {
        return this.getAuthors().stream().map(author -> author.getFamilyGiven(abbreviate)).collect(Collectors.joining(" and "));
    }

    public String getAsLastFirstFirstLastNamesWithAnd(boolean abbreviate) {
        return switch (this.authors.size()) {
            case 0 -> "";
            case 1 -> this.authors.getFirst().getFamilyGiven(abbreviate);
            default -> this.authors.stream().skip(1L).map(author -> author.getGivenFamily(abbreviate)).collect(Collectors.joining(" and ", this.authors.getFirst().getFamilyGiven(abbreviate) + " and ", ""));
        };
    }

    public String getAsFirstLastNames(boolean abbreviate, boolean oxfordComma) {
        return AuthorList.andCoordinatedConjunction(this.getAuthors(), author -> author.getGivenFamily(abbreviate), oxfordComma);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthorList)) {
            return false;
        }
        AuthorList a = (AuthorList)o;
        return this.authors.equals(a.authors);
    }

    public int hashCode() {
        return Objects.hash(this.authors);
    }

    public String getAsFirstLastNamesWithAnd() {
        return this.getAuthors().stream().map(author -> author.getGivenFamily(false)).collect(Collectors.joining(" and "));
    }

    public String getForAlphabetization() {
        return this.getAuthors().stream().map(Author::getNameForAlphabetization).collect(Collectors.joining(" and "));
    }

    @Override
    public Iterator<Author> iterator() {
        return this.authors.iterator();
    }
}

