/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.SequencedSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.EntryConverter;
import org.jabref.model.entry.field.BibField;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldPriority;
import org.jabref.model.entry.field.OrFields;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.EntryType;

public class BibEntryType
implements Comparable<BibEntryType> {
    private final EntryType type;
    private final SequencedSet<BibField> allFields;
    private final SequencedSet<OrFields> requiredFields;

    public BibEntryType(EntryType type, Collection<BibField> allFields, Collection<OrFields> requiredFields) {
        this.type = Objects.requireNonNull(type);
        this.allFields = new LinkedHashSet<BibField>(allFields);
        this.requiredFields = new LinkedHashSet<OrFields>(requiredFields);
    }

    public EntryType getType() {
        return this.type;
    }

    public SequencedSet<BibField> getOptionalFields() {
        return this.getAllBibFields().stream().filter(field -> !this.isRequired(field.field())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean isRequired(Field field) {
        return this.getRequiredFields().stream().anyMatch(fields -> fields.contains(field));
    }

    public SequencedSet<OrFields> getRequiredFields() {
        return Collections.unmodifiableSequencedSet(this.requiredFields);
    }

    public SequencedSet<BibField> getAllBibFields() {
        return Collections.unmodifiableSequencedSet(this.allFields);
    }

    public Set<Field> getAllFields() {
        return this.allFields.stream().map(BibField::field).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public SequencedSet<Field> getImportantOptionalFields() {
        return this.getOptionalFields().stream().filter(field -> field.priority() == FieldPriority.IMPORTANT).map(BibField::field).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public SequencedSet<Field> getDetailOptionalFields() {
        return this.getOptionalFields().stream().filter(field -> field.priority() == FieldPriority.DETAIL).map(BibField::field).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<Field> getDeprecatedFields(BibDatabaseMode mode) {
        if (mode == BibDatabaseMode.BIBTEX) {
            return Set.of();
        }
        HashSet<Field> deprecatedFields = new HashSet<Field>(EntryConverter.FIELD_ALIASES_BIBTEX_TO_BIBLATEX.keySet());
        deprecatedFields.retainAll(this.getOptionalFieldsAndAliases());
        deprecatedFields.add(StandardField.MONTH);
        return deprecatedFields;
    }

    public SequencedSet<Field> getDetailOptionalNotDeprecatedFields(BibDatabaseMode mode) {
        LinkedHashSet<Field> optionalFieldsNotPrimaryOrDeprecated = new LinkedHashSet<Field>(this.getDetailOptionalFields());
        optionalFieldsNotPrimaryOrDeprecated.removeAll(this.getDeprecatedFields(mode));
        return optionalFieldsNotPrimaryOrDeprecated;
    }

    private SequencedSet<Field> getOptionalFieldsAndAliases() {
        LinkedHashSet<Field> optionalFieldsAndAliases = new LinkedHashSet<Field>(this.getOptionalFields().size());
        for (BibField field : this.getOptionalFields()) {
            optionalFieldsAndAliases.add(field.field());
            if (!EntryConverter.FIELD_ALIASES_BIBTEX_TO_BIBLATEX.containsKey(field.field())) continue;
            optionalFieldsAndAliases.add(field.field());
        }
        return optionalFieldsAndAliases;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BibEntryType that = (BibEntryType)o;
        return this.type.equals(that.type) && Objects.equals(this.requiredFields, that.requiredFields) && Objects.equals(this.allFields, that.allFields);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.requiredFields, this.allFields);
    }

    public String toString() {
        return "BibEntryType{type=" + String.valueOf(this.type) + ", allFields=" + String.valueOf(this.allFields) + ", requiredFields=" + String.valueOf(this.requiredFields) + "}";
    }

    @Override
    public int compareTo(BibEntryType o) {
        return this.getType().getName().compareTo(o.getType().getName());
    }
}

