/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.jabref.model.entry.Month;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Date {
    public static final String DATE_REGEX;
    private static final DateTimeFormatter NORMALIZED_DATE_FORMATTER;
    private static final DateTimeFormatter SIMPLE_DATE_FORMATS;
    private static final Logger LOGGER;
    private final TemporalAccessor date;
    private final TemporalAccessor endDate;

    public Date(int year, int month, int dayOfMonth) {
        this(LocalDate.of(year, month, dayOfMonth));
    }

    public Date(int year, int month) {
        this(YearMonth.of(year, month));
    }

    public Date(int year) {
        this(Year.of(year));
    }

    public Date(TemporalAccessor date) {
        this.date = date;
        this.endDate = null;
    }

    public Date(TemporalAccessor date, TemporalAccessor endDate) {
        this.date = date;
        this.endDate = endDate;
    }

    public static Optional<Date> parse(String dateString) {
        Objects.requireNonNull(dateString);
        if (dateString.isEmpty()) {
            return Optional.empty();
        }
        if (dateString.matches("\\d{4}/\\d{4}|\\d{4}-\\d{2}/\\d{4}-\\d{2}|\\d{4}-\\d{2}-\\d{2}/\\d{4}-\\d{2}-\\d{2}|(?i)(January|February|March|April|May|June|July|August|September|October|November|December)( |\\-)(\\d{1,4})/(January|February|March|April|May|June|July|August|September|October|November|December)( |\\-)(\\d{1,4})(?i-)|(?i)(\\d{1,2})( )(January|February|March|April|May|June|July|August|September|October|November|December)( |\\-)(\\d{1,4})/(\\d{1,2})( )(January|February|March|April|May|June|July|August|September|October|November|December)( |\\-)(\\d{1,4})(?i-)")) {
            try {
                String[] strDates = dateString.split("/");
                TemporalAccessor parsedDate = SIMPLE_DATE_FORMATS.parse(strDates[0].strip());
                TemporalAccessor parsedEndDate = SIMPLE_DATE_FORMATS.parse(strDates[1].strip());
                return Optional.of(new Date(parsedDate, parsedEndDate));
            }
            catch (DateTimeParseException e) {
                LOGGER.warn("Invalid Date format for range", (Throwable)e);
                return Optional.empty();
            }
        }
        if (dateString.matches("\\d{4} / \\d{4}|\\d{4}-\\d{2} / \\d{4}-\\d{2}|\\d{4}-\\d{2}-\\d{2} / \\d{4}-\\d{2}-\\d{2}|(?i)(January|February|March|April|May|June|July|August|September|October|November|December)( |\\-)(\\d{1,4}) / (January|February|March|April|May|June|July|August|September|October|November|December)( |\\-)(\\d{1,4})(?i-)|(?i)(\\d{1,2})( )(January|February|March|April|May|June|July|August|September|October|November|December)( |\\-)(\\d{1,4}) / (\\d{1,2})( )(January|February|March|April|May|June|July|August|September|October|November|December)( |\\-)(\\d{1,4})(?i-)")) {
            try {
                String[] strDates = dateString.split(" / ");
                TemporalAccessor parsedDate = SIMPLE_DATE_FORMATS.parse(strDates[0].strip());
                TemporalAccessor parsedEndDate = SIMPLE_DATE_FORMATS.parse(strDates[1].strip());
                return Optional.of(new Date(parsedDate, parsedEndDate));
            }
            catch (DateTimeParseException e) {
                LOGGER.warn("Invalid Date format range", (Throwable)e);
                return Optional.empty();
            }
        }
        if (dateString.matches("\\d{1,4} BC/\\d{1,4} AD|\\d{1,4} BC/\\d{1,4} BC|\\d{1,4} AD/\\d{1,4} AD|\\d{1,4}-\\d{1,2} BC/\\d{1,4}-\\d{1,2} AD|\\d{1,4}-\\d{1,2} BC/\\d{1,4}-\\d{1,2} BC|\\d{1,4}-\\d{1,2} AD/\\d{1,4}-\\d{1,2} AD")) {
            try {
                String[] strDates = dateString.split("/");
                TemporalAccessor parsedDate = Date.parseDateWithEraIndicator(strDates[0]);
                TemporalAccessor parsedEndDate = Date.parseDateWithEraIndicator(strDates[1]);
                return Optional.of(new Date(parsedDate, parsedEndDate));
            }
            catch (DateTimeParseException e) {
                LOGGER.warn("Invalid Date format range", (Throwable)e);
                return Optional.empty();
            }
        }
        if (dateString.matches("\\d{1,4} BC / \\d{1,4} AD|\\d{1,4} BC / \\d{1,4} BC|\\d{1,4} AD / \\d{1,4} AD|\\d{1,4}-\\d{1,2} BC / \\d{1,4}-\\d{1,2} AD|\\d{1,4}-\\d{1,2} BC / \\d{1,4}-\\d{1,2} BC|\\d{1,4}-\\d{1,2} AD / \\d{1,4}-\\d{1,2} AD")) {
            try {
                String[] strDates = dateString.split(" / ");
                TemporalAccessor parsedDate = Date.parseDateWithEraIndicator(strDates[0]);
                TemporalAccessor parsedEndDate = Date.parseDateWithEraIndicator(strDates[1]);
                return Optional.of(new Date(parsedDate, parsedEndDate));
            }
            catch (DateTimeParseException e) {
                LOGGER.warn("Invalid Date format range", (Throwable)e);
                return Optional.empty();
            }
        }
        if (dateString.matches("\\d{4}-|\\d{4}\\?")) {
            try {
                String year = dateString.substring(0, dateString.length() - 1);
                TemporalAccessor parsedDate = SIMPLE_DATE_FORMATS.parse(year);
                return Optional.of(new Date(parsedDate));
            }
            catch (DateTimeParseException e) {
                LOGGER.debug("Invalid Date format", (Throwable)e);
                return Optional.empty();
            }
        }
        if (dateString.matches("\\d{1,4} BC|\\d{1,4} AD|\\d{1,4}-\\d{1,2} BC|\\d{1,4}-\\d{1,2} AD")) {
            try {
                TemporalAccessor date = Date.parseDateWithEraIndicator(dateString);
                return Optional.of(new Date(date));
            }
            catch (DateTimeParseException e) {
                LOGGER.warn("Invalid Date format with era indicator", (Throwable)e);
                return Optional.empty();
            }
        }
        try {
            TemporalAccessor parsedDate = SIMPLE_DATE_FORMATS.parse(dateString);
            return Optional.of(new Date(parsedDate));
        }
        catch (DateTimeParseException e) {
            LOGGER.debug("Invalid Date format", (Throwable)e);
            return Optional.empty();
        }
    }

    public static Optional<Date> parse(Optional<String> yearValue, Optional<String> monthValue, Optional<String> dayValue) {
        Optional<Year> year = yearValue.flatMap(Date::convertToInt).map(Year::of);
        Optional month = monthValue.flatMap(Month::parse);
        Optional day = dayValue.flatMap(Date::convertToInt);
        if (year.isPresent()) {
            Object date = month.isPresent() ? (day.isPresent() ? LocalDate.of(year.get().getValue(), ((Month)((Object)month.get())).getNumber(), (int)((Integer)day.get())) : YearMonth.of(year.get().getValue(), ((Month)((Object)month.get())).getNumber())) : (TemporalAccessor)year.get();
            return Optional.of(new Date((TemporalAccessor)date));
        }
        return Optional.empty();
    }

    private static Optional<Integer> convertToInt(String value) {
        try {
            return Optional.of(Integer.valueOf(value));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    private static TemporalAccessor parseDateWithEraIndicator(String dateString) {
        String yearString = dateString.strip().substring(0, dateString.length() - 2);
        String[] parts = yearString.split("-");
        int year = Integer.parseInt(parts[0].strip());
        if (dateString.endsWith("BC")) {
            year = 1 - year;
        }
        if (parts.length > 1) {
            int month = Integer.parseInt(parts[1].strip());
            return YearMonth.of(year, month);
        }
        return Year.of(year);
    }

    public String getNormalized() {
        return NORMALIZED_DATE_FORMATTER.format(this.date);
    }

    public Optional<Integer> getYear() {
        return this.get(ChronoField.YEAR);
    }

    public Optional<Integer> get(ChronoField field) {
        if (this.date.isSupported(field)) {
            return Optional.of(this.date.get(field));
        }
        return Optional.empty();
    }

    public Optional<Month> getMonth() {
        return this.get(ChronoField.MONTH_OF_YEAR).flatMap(Month::getMonthByNumber);
    }

    public Optional<Integer> getDay() {
        return this.get(ChronoField.DAY_OF_MONTH);
    }

    public TemporalAccessor toTemporalAccessor() {
        return this.date;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Date date1 = (Date)o;
        return Objects.equals(this.getYear(), date1.getYear()) && Objects.equals(this.getMonth(), date1.getMonth()) && Objects.equals(this.getDay(), date1.getDay()) && Objects.equals(this.get(ChronoField.HOUR_OF_DAY), date1.get(ChronoField.HOUR_OF_DAY)) && Objects.equals(this.get(ChronoField.MINUTE_OF_HOUR), date1.get(ChronoField.MINUTE_OF_HOUR)) && Objects.equals(this.get(ChronoField.SECOND_OF_DAY), date1.get(ChronoField.SECOND_OF_DAY)) && Objects.equals(this.get(ChronoField.OFFSET_SECONDS), date1.get(ChronoField.OFFSET_SECONDS));
    }

    public String toString() {
        String formattedDate = this.date.toString();
        if (this.date.isSupported(ChronoField.OFFSET_SECONDS)) {
            formattedDate = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.date);
        } else if (this.date.isSupported(ChronoField.HOUR_OF_DAY)) {
            formattedDate = DateTimeFormatter.ISO_DATE_TIME.format(this.date);
        } else if (this.date.isSupported(ChronoField.MONTH_OF_YEAR) && this.date.isSupported(ChronoField.DAY_OF_MONTH)) {
            formattedDate = DateTimeFormatter.ISO_DATE.format(this.date);
        }
        return "Date{date=" + formattedDate + "}";
    }

    public int hashCode() {
        return Objects.hash(this.getYear(), this.getMonth(), this.getDay(), this.get(ChronoField.HOUR_OF_DAY), this.get(ChronoField.MINUTE_OF_HOUR), this.get(ChronoField.OFFSET_SECONDS));
    }

    static {
        NORMALIZED_DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu[-MM][-dd]");
        LOGGER = LoggerFactory.getLogger(Date.class);
        List<String> formatStrings = Arrays.asList("uuuu-MM-dd'T'HH:mm[:ss][xxx][xx][X]", "uuuu-MM-dd'T'HH:m[:ss][xxx][xx][X]", "uuuu-MM-dd'T'H:mm[:ss][xxx][xx][X]", "uuuu-MM-dd'T'H:m[:ss][xxx][xx][X]", "uuuu-MM-dd'T'HH[:ss][xxx][xx][X]", "uuuu-MM-dd'T'H[:ss][xxx][xx][X]", "uuuu-M-d", "uuuu-M", "uuuu/M", "d-M-uuuu", "M-uuuu", "M/uuuu", "M/uu", "MMMM d, uuuu", "MMMM, uuuu", "MMMM  uuuu", "d.M.uuuu", "uuuu.M.d", "uuuu", "MMM, uuuu", "MMM. uuuu", "MMM uuuu", "uuuu.MM.d", "d MMMM u/d MMMM u", "d MMMM u", "d MMMM u / d MMMM u", "u'-'", "u'?'", "u G", "uuuu G", "u G/u G", "uuuu G/uuuu G", "uuuu-MM G/uuuu-MM G");
        SIMPLE_DATE_FORMATS = formatStrings.stream().map(DateTimeFormatter::ofPattern).reduce(new DateTimeFormatterBuilder(), DateTimeFormatterBuilder::appendOptional, (builder, formatterBuilder) -> builder.append(formatterBuilder.toFormatter())).toFormatter(Locale.US);
        DATE_REGEX = "\\d{4}-\\d{1,2}-\\d{1,2}|\\d{4}\\.\\d{1,2}\\.\\d{1,2}|(January|February|March|April|May|June|July|August|September|October|November|December) \\d{1,2}, \\d{4}";
    }
}

