/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.field;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldProperty;

public enum InternalField implements Field
{
    KEY_FIELD("citationkey"),
    TYPE_HEADER("entrytype"),
    OBSOLETE_TYPE_HEADER("bibtextype"),
    MARKED_INTERNAL("__markedentry"),
    BIBTEX_STRING("__string"),
    INTERNAL_ALL_FIELD("all"),
    INTERNAL_ALL_TEXT_FIELDS_FIELD("all-text-fields"),
    INTERNAL_ID_FIELD("JabRef-internal-id");

    private final String name;
    private final EnumSet<FieldProperty> properties;

    private InternalField(String name) {
        this.name = name;
        this.properties = EnumSet.noneOf(FieldProperty.class);
    }

    private InternalField(String name, FieldProperty first, FieldProperty ... rest) {
        this.name = name;
        this.properties = EnumSet.of(first, rest);
    }

    public static Optional<InternalField> fromName(String name) {
        if ("bibtexkey".equalsIgnoreCase(name)) {
            return Optional.of(KEY_FIELD);
        }
        return Arrays.stream(InternalField.values()).filter(field -> field.getName().equalsIgnoreCase(name)).findAny();
    }

    @Override
    public EnumSet<FieldProperty> getProperties() {
        return this.properties;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isStandardField() {
        return false;
    }
}

