/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.identifier;

import java.net.URI;
import java.util.Optional;
import org.jabref.model.entry.identifier.EprintIdentifier;

public class ARK
extends EprintIdentifier {
    private final String ark;

    private ARK(String ark) {
        this.ark = ark;
    }

    public static Optional<ARK> parse(String value) {
        return Optional.of(new ARK(value));
    }

    @Override
    public String getNormalized() {
        String cleanARK = this.ark.strip();
        return cleanARK.replaceFirst("^ark:/", "");
    }

    @Override
    public Optional<URI> getExternalURI() {
        return Optional.of(URI.create("https://n2t.net/ark:/" + this.getNormalized()));
    }
}

