/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.identifier;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IacrEprint
implements Identifier {
    public static final URI RESOLVER = URI.create("https://ia.cr");
    private static final Logger LOGGER = LoggerFactory.getLogger(IacrEprint.class);
    private static final String IACR_EPRINT_EXP = "\\d{4}\\/\\d{3,5}";
    private final String iacrEprint;

    IacrEprint(String iacrEprint) {
        Objects.requireNonNull(iacrEprint);
        String trimmedId = iacrEprint.trim();
        if (!IacrEprint.matchesExcepted(trimmedId)) {
            throw new IllegalArgumentException(trimmedId + " is not a valid IacrEprint identifier.");
        }
        Matcher matcher = Pattern.compile(IACR_EPRINT_EXP).matcher(trimmedId);
        matcher.find();
        this.iacrEprint = matcher.group(0);
    }

    private static boolean matchesExcepted(String identifier) {
        return identifier.matches("(https\\:\\/\\/)?(ia\\.cr\\/|eprint\\.iacr\\.org\\/)?\\d{4}\\/\\d{3,5}");
    }

    public static Optional<IacrEprint> parse(String identifier) {
        String trimmed = identifier.strip();
        try {
            return Optional.of(new IacrEprint(trimmed));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }

    @Override
    public String getNormalized() {
        return this.iacrEprint;
    }

    @Override
    public Field getDefaultField() {
        return StandardField.EPRINT;
    }

    @Override
    public Optional<URI> getExternalURI() {
        try {
            URI uri = new URI(RESOLVER.getScheme(), RESOLVER.getHost(), "/" + this.iacrEprint, null);
            return Optional.of(uri);
        }
        catch (URISyntaxException e) {
            LOGGER.error(this.iacrEprint + " could not be encoded as URI.", (Throwable)e);
            return Optional.empty();
        }
    }

    public String getAsciiUrl() {
        return this.getExternalURI().map(URI::toASCIIString).orElse("");
    }
}

