/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.types;

import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.jabref.model.entry.types.EntryType;

public enum BiblatexSoftwareEntryType implements EntryType
{
    Dataset("Dataset"),
    SoftwareVersion("SoftwareVersion"),
    SoftwareModule("SoftwareModule"),
    CodeFragment("CodeFragment");

    private final String displayName;

    private BiblatexSoftwareEntryType(String displayName) {
        this.displayName = displayName;
    }

    public static Optional<BiblatexSoftwareEntryType> fromName(String name) {
        return Arrays.stream(BiblatexSoftwareEntryType.values()).filter(field -> field.getName().equalsIgnoreCase(name)).findAny();
    }

    @Override
    public String getName() {
        return this.displayName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }
}

