/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.groups;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.search.SearchMatcher;
import org.jabref.model.strings.StringUtil;

public abstract class AbstractGroup
implements SearchMatcher {
    protected final StringProperty name = new SimpleStringProperty();
    protected final GroupHierarchyType context;
    protected Optional<Color> color = Optional.empty();
    protected boolean isExpanded = true;
    protected Optional<String> description = Optional.empty();
    protected Optional<String> iconName = Optional.empty();

    protected AbstractGroup(String name, GroupHierarchyType context) {
        this.name.setValue(name);
        this.context = Objects.requireNonNull(context);
    }

    public String toString() {
        return "AbstractGroup{name='" + this.name.getValue() + "', context=" + String.valueOf((Object)this.context) + ", color=" + String.valueOf(this.color) + ", isExpanded=" + this.isExpanded + ", description=" + String.valueOf(this.description) + ", iconName=" + String.valueOf(this.iconName) + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractGroup that = (AbstractGroup)other;
        return Objects.equals(this.name.getValue(), that.name.getValue()) && Objects.equals(this.description, that.description) && Objects.equals((Object)this.context, (Object)that.context);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name.getValue(), this.description, this.context});
    }

    public Optional<Color> getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = Optional.ofNullable(color);
    }

    public void setColor(String colorString) {
        if (StringUtil.isBlank(colorString)) {
            this.color = Optional.empty();
        } else {
            this.setColor(Color.valueOf((String)colorString));
        }
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = StringUtil.isBlank(description) ? Optional.empty() : Optional.of(description);
    }

    public Optional<String> getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = StringUtil.isBlank(iconName) ? Optional.empty() : Optional.of(iconName);
    }

    public GroupHierarchyType getHierarchicalContext() {
        return this.context;
    }

    public final String getName() {
        return this.name.getValue();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public abstract boolean contains(BibEntry var1);

    @Override
    public boolean isMatch(BibEntry entry) {
        return this.contains(entry);
    }

    public boolean containsAny(List<BibEntry> entries) {
        for (BibEntry entry : entries) {
            if (!this.contains(entry)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(List<BibEntry> entries) {
        for (BibEntry entry : entries) {
            if (this.contains(entry)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isDynamic();

    public abstract AbstractGroup deepCopy();
}

