/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.groups;

import java.util.EnumSet;
import java.util.Objects;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.search.GroupSearchQuery;
import org.jabref.model.search.rules.SearchRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchGroup
extends AbstractGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchGroup.class);
    private final GroupSearchQuery query;

    public SearchGroup(String name, GroupHierarchyType context, String searchExpression, EnumSet<SearchRules.SearchFlags> searchFlags) {
        super(name, context);
        this.query = new GroupSearchQuery(searchExpression, searchFlags);
    }

    public String getSearchExpression() {
        return this.query.getSearchExpression();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchGroup)) {
            return false;
        }
        SearchGroup other = (SearchGroup)o;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals((Object)this.getHierarchicalContext(), (Object)other.getHierarchicalContext()) && Objects.equals(this.getSearchExpression(), other.getSearchExpression()) && Objects.equals(this.getSearchFlags(), other.getSearchFlags());
    }

    @Override
    public boolean contains(BibEntry entry) {
        return this.query.isMatch(entry);
    }

    public EnumSet<SearchRules.SearchFlags> getSearchFlags() {
        return this.query.getSearchFlags();
    }

    @Override
    public AbstractGroup deepCopy() {
        try {
            return new SearchGroup(this.getName(), this.getHierarchicalContext(), this.getSearchExpression(), this.getSearchFlags());
        }
        catch (Throwable t) {
            LOGGER.error("Internal error in SearchGroup.deepCopy(). Please report this on https://github.com/JabRef/jabref/issues", t);
            return null;
        }
    }

    @Override
    public String toString() {
        return "SearchGroup [query=" + String.valueOf(this.query) + ", name=" + String.valueOf(this.name) + ", searchFlags=" + String.valueOf(this.getSearchFlags()) + ",  context=" + String.valueOf((Object)this.context) + ", color=" + String.valueOf(this.color) + ", isExpanded=" + this.isExpanded + ", description=" + String.valueOf(this.description) + ", iconName=" + String.valueOf(this.iconName) + "]";
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getHierarchicalContext(), this.getSearchExpression(), this.getSearchFlags()});
    }
}

