/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.metadata;

import com.google.common.eventbus.EventBus;
import com.tobiasdiez.easybind.optional.OptionalBinding;
import com.tobiasdiez.easybind.optional.OptionalWrapper;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.jabref.architecture.AllowedToUseLogic;
import org.jabref.logic.citationkeypattern.AbstractCitationKeyPatterns;
import org.jabref.logic.citationkeypattern.CitationKeyPattern;
import org.jabref.logic.citationkeypattern.DatabaseCitationKeyPatterns;
import org.jabref.logic.citationkeypattern.GlobalCitationKeyPatterns;
import org.jabref.logic.cleanup.FieldFormatterCleanups;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.database.event.ChangePropagation;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.groups.event.GroupUpdatedEvent;
import org.jabref.model.metadata.ContentSelector;
import org.jabref.model.metadata.ContentSelectors;
import org.jabref.model.metadata.SaveOrder;
import org.jabref.model.metadata.event.MetaDataChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AllowedToUseLogic(value="because it needs access to citation pattern and cleanups")
public class MetaData {
    public static final String META_FLAG = "jabref-meta: ";
    public static final String ENTRYTYPE_FLAG = "jabref-entrytype: ";
    public static final String SAVE_ORDER_CONFIG = "saveOrderConfig";
    public static final String SAVE_ACTIONS = "saveActions";
    public static final String PREFIX_KEYPATTERN = "keypattern_";
    public static final String KEYPATTERNDEFAULT = "keypatterndefault";
    public static final String DATABASE_TYPE = "databaseType";
    public static final String VERSION_DB_STRUCT = "VersionDBStructure";
    public static final String GROUPSTREE = "grouping";
    public static final String GROUPSTREE_LEGACY = "groupstree";
    public static final String FILE_DIRECTORY = "fileDirectory";
    public static final String FILE_DIRECTORY_LATEX = "fileDirectoryLatex";
    public static final String PROTECTED_FLAG_META = "protectedFlag";
    public static final String SELECTOR_META_PREFIX = "selector_";
    public static final String BIBDESK_STATIC_FLAG = "BibDesk Static Groups";
    public static final char ESCAPE_CHARACTER = '\\';
    public static final char SEPARATOR_CHARACTER = ';';
    public static final String SEPARATOR_STRING = String.valueOf(';');
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaData.class);
    private final EventBus eventBus = new EventBus();
    private final Map<EntryType, String> citeKeyPatterns = new HashMap<EntryType, String>();
    private final Map<String, String> userFileDirectory = new HashMap<String, String>();
    private final Map<String, Path> laTexFileDirectory = new HashMap<String, Path>();
    private final ObjectProperty<GroupTreeNode> groupsRoot = new SimpleObjectProperty(null);
    private final OptionalBinding<GroupTreeNode> groupsRootBinding = new OptionalWrapper(this.groupsRoot);
    private Charset encoding;
    private SaveOrder saveOrder;
    private String defaultCiteKeyPattern;
    private FieldFormatterCleanups saveActions;
    private BibDatabaseMode mode;
    private boolean isProtected;
    private String defaultFileDirectory;
    private final ContentSelectors contentSelectors = new ContentSelectors();
    private final Map<String, List<String>> unknownMetaData = new HashMap<String, List<String>>();
    private boolean isEventPropagationEnabled = true;
    private boolean encodingExplicitlySupplied;
    private String versionDBStructure;

    public Optional<SaveOrder> getSaveOrder() {
        return Optional.ofNullable(this.saveOrder);
    }

    public void setSaveOrder(SaveOrder saveOrder) {
        this.saveOrder = saveOrder;
        this.postChange();
    }

    public Optional<GroupTreeNode> getGroups() {
        return (Optional)this.groupsRootBinding.getValue();
    }

    public OptionalBinding<GroupTreeNode> groupsBinding() {
        return this.groupsRootBinding;
    }

    public void setGroups(GroupTreeNode root) {
        Objects.requireNonNull(root);
        this.groupsRoot.setValue((Object)root);
        root.subscribeToDescendantChanged(groupTreeNode -> this.groupsRootBinding.invalidate());
        root.subscribeToDescendantChanged(groupTreeNode -> this.eventBus.post((Object)new GroupUpdatedEvent(this)));
        this.eventBus.post((Object)new GroupUpdatedEvent(this));
        this.postChange();
    }

    public AbstractCitationKeyPatterns getCiteKeyPatterns(GlobalCitationKeyPatterns globalPatterns) {
        Objects.requireNonNull(globalPatterns);
        DatabaseCitationKeyPatterns bibtexKeyPatterns = new DatabaseCitationKeyPatterns(globalPatterns);
        this.citeKeyPatterns.forEach(bibtexKeyPatterns::addCitationKeyPattern);
        this.getDefaultCiteKeyPattern().ifPresent(bibtexKeyPatterns::setDefaultValue);
        return bibtexKeyPatterns;
    }

    public void setCiteKeyPattern(AbstractCitationKeyPatterns bibtexKeyPatterns) {
        Objects.requireNonNull(bibtexKeyPatterns);
        CitationKeyPattern defaultValue = bibtexKeyPatterns.getDefaultValue();
        Map<EntryType, CitationKeyPattern> nonDefaultPatterns = bibtexKeyPatterns.getPatterns();
        this.setCiteKeyPattern(defaultValue, nonDefaultPatterns);
    }

    public void setCiteKeyPattern(CitationKeyPattern defaultValue, Map<EntryType, CitationKeyPattern> nonDefaultPatterns) {
        this.citeKeyPatterns.clear();
        for (Map.Entry<EntryType, CitationKeyPattern> pattern : nonDefaultPatterns.entrySet()) {
            this.citeKeyPatterns.put(pattern.getKey(), pattern.getValue().stringRepresentation());
        }
        this.defaultCiteKeyPattern = defaultValue.equals(CitationKeyPattern.NULL_CITATION_KEY_PATTERN) ? null : defaultValue.stringRepresentation();
        this.postChange();
    }

    public Optional<FieldFormatterCleanups> getSaveActions() {
        return Optional.ofNullable(this.saveActions);
    }

    public void setSaveActions(FieldFormatterCleanups saveActions) {
        this.saveActions = Objects.requireNonNull(saveActions);
        this.postChange();
    }

    public Optional<BibDatabaseMode> getMode() {
        return Optional.ofNullable(this.mode);
    }

    public void setMode(BibDatabaseMode mode) {
        if (mode == this.mode) {
            return;
        }
        this.mode = Objects.requireNonNull(mode);
        this.postChange();
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public ContentSelectors getContentSelectors() {
        return this.contentSelectors;
    }

    public SortedSet<ContentSelector> getContentSelectorsSorted() {
        return this.contentSelectors.getContentSelectors();
    }

    public void addContentSelector(ContentSelector contentSelector) {
        this.contentSelectors.addContentSelector(contentSelector);
        this.postChange();
    }

    public void clearContentSelectors(Field field) {
        this.contentSelectors.removeSelector(field);
        this.postChange();
    }

    public List<String> getContentSelectorValuesForField(Field field) {
        return this.contentSelectors.getSelectorValuesForField(field);
    }

    public Optional<String> getDefaultFileDirectory() {
        return Optional.ofNullable(this.defaultFileDirectory);
    }

    public void setDefaultFileDirectory(String path) {
        this.defaultFileDirectory = Objects.requireNonNull(path).trim();
        this.postChange();
    }

    public Optional<String> getVersionDBStructure() {
        return Optional.ofNullable(this.versionDBStructure);
    }

    public void setVersionDBStructure(String version) {
        this.versionDBStructure = Objects.requireNonNull(version).trim();
        this.postChange();
    }

    public Optional<String> getUserFileDirectory(String user) {
        return Optional.ofNullable(this.userFileDirectory.get(user));
    }

    public void markAsProtected() {
        this.isProtected = true;
        this.postChange();
    }

    public void clearDefaultFileDirectory() {
        this.defaultFileDirectory = null;
        this.postChange();
    }

    public void setUserFileDirectory(String user, String path) {
        this.userFileDirectory.put(Objects.requireNonNull(user), Objects.requireNonNull(path));
        this.postChange();
    }

    public void clearUserFileDirectory(String user) {
        this.userFileDirectory.remove(user);
        this.postChange();
    }

    public Optional<Path> getLatexFileDirectory(String user) {
        return Optional.ofNullable(this.laTexFileDirectory.get(user));
    }

    public void setLatexFileDirectory(String user, Path path) {
        this.laTexFileDirectory.put(Objects.requireNonNull(user), Objects.requireNonNull(path));
        this.postChange();
    }

    public void clearLatexFileDirectory(String user) {
        this.laTexFileDirectory.remove(user);
        this.postChange();
    }

    public void markAsNotProtected() {
        this.isProtected = false;
        this.postChange();
    }

    public void clearSaveActions() {
        this.saveActions = null;
        this.postChange();
    }

    public void clearSaveOrder() {
        this.saveOrder = null;
        this.postChange();
    }

    private void postChange() {
        if (this.isEventPropagationEnabled) {
            this.eventBus.post((Object)new MetaDataChangedEvent(this));
        }
    }

    public Optional<Charset> getEncoding() {
        return Optional.ofNullable(this.encoding);
    }

    public void setEncoding(Charset encoding) {
        this.setEncoding(encoding, ChangePropagation.POST_EVENT);
    }

    public void setEncoding(Charset encoding, ChangePropagation postChanges) {
        this.encoding = Objects.requireNonNull(encoding);
        if (postChanges == ChangePropagation.POST_EVENT) {
            this.postChange();
        }
    }

    public boolean getEncodingExplicitlySupplied() {
        return this.encodingExplicitlySupplied;
    }

    public void setEncodingExplicitlySupplied(boolean encodingExplicitlySupplied) {
        this.encodingExplicitlySupplied = encodingExplicitlySupplied;
    }

    public void setEventPropagation(boolean enabled) {
        this.isEventPropagationEnabled = enabled;
    }

    public void registerListener(Object listener) {
        this.eventBus.register(listener);
    }

    public void unregisterListener(Object listener) {
        try {
            this.eventBus.unregister(listener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public Optional<String> getDefaultCiteKeyPattern() {
        return Optional.ofNullable(this.defaultCiteKeyPattern);
    }

    public boolean isEmpty() {
        return this.equals(new MetaData());
    }

    public Map<String, String> getUserFileDirectories() {
        return Collections.unmodifiableMap(this.userFileDirectory);
    }

    public Map<String, Path> getLatexFileDirectories() {
        return Collections.unmodifiableMap(this.laTexFileDirectory);
    }

    public Map<String, List<String>> getUnknownMetaData() {
        return Collections.unmodifiableMap(this.unknownMetaData);
    }

    public void putUnknownMetaDataItem(String key, List<String> value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.unknownMetaData.put(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetaData)) {
            return false;
        }
        MetaData that = (MetaData)o;
        return this.isProtected == that.isProtected && Objects.equals(this.groupsRoot.getValue(), that.groupsRoot.getValue()) && Objects.equals(this.encoding, that.encoding) && Objects.equals(this.encodingExplicitlySupplied, that.encodingExplicitlySupplied) && Objects.equals(this.saveOrder, that.saveOrder) && Objects.equals(this.citeKeyPatterns, that.citeKeyPatterns) && Objects.equals(this.userFileDirectory, that.userFileDirectory) && Objects.equals(this.laTexFileDirectory, that.laTexFileDirectory) && Objects.equals(this.defaultCiteKeyPattern, that.defaultCiteKeyPattern) && Objects.equals(this.saveActions, that.saveActions) && this.mode == that.mode && Objects.equals(this.defaultFileDirectory, that.defaultFileDirectory) && Objects.equals(this.contentSelectors, that.contentSelectors) && Objects.equals(this.versionDBStructure, that.versionDBStructure);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isProtected, this.groupsRoot.getValue(), this.encoding, this.encodingExplicitlySupplied, this.saveOrder, this.citeKeyPatterns, this.userFileDirectory, this.laTexFileDirectory, this.defaultCiteKeyPattern, this.saveActions, this.mode, this.defaultFileDirectory, this.contentSelectors, this.versionDBStructure});
    }

    public String toString() {
        return "MetaData [citeKeyPatterns=" + String.valueOf(this.citeKeyPatterns) + ", userFileDirectory=" + String.valueOf(this.userFileDirectory) + ", laTexFileDirectory=" + String.valueOf(this.laTexFileDirectory) + ", groupsRoot=" + String.valueOf(this.groupsRoot) + ", encoding=" + String.valueOf(this.encoding) + ", saveOrderConfig=" + String.valueOf(this.saveOrder) + ", defaultCiteKeyPattern=" + this.defaultCiteKeyPattern + ", saveActions=" + String.valueOf(this.saveActions) + ", mode=" + String.valueOf((Object)this.mode) + ", isProtected=" + this.isProtected + ", defaultFileDirectory=" + this.defaultFileDirectory + ", contentSelectors=" + String.valueOf(this.contentSelectors) + ", encodingExplicitlySupplied=" + this.encodingExplicitlySupplied + ", VersionDBStructure=" + this.versionDBStructure + "]";
    }
}

